<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {
	
    function __construct(){
        parent::__construct();
		date_default_timezone_set('Asia/Jakarta'); 
		$this->load->database();
		$this->load->library('authorization');
		$this->load->library('session');
    }
	
	public function index()
	{
		$data = array(
			'content'	=>	'main_login'
		);
		
		$this->load->view($data['content'],$data);
	}
	
    function signin()
    {
		$result['url'] = '';
		$result['error_msg'] = '';
		$result['url'] = 'main';
		$error = '';
		$data['username'] = $this->input->post('t_username');
		$data['password'] = $this->input->post('t_password');
		$remember = $this->input->post("remember");
		// echo $remember;
		// exit;
		if (!$data['username'])
			$error .= 'Username tidak boleh kosong, ';
		if (!$data['password'])
			$error .= 'Password belum diisi, ';
		if (!$error)
		{
			$return = $this->authorization->do_login($data);
			// echo $this->db->last_query();
			if($return['status'])
			{
				if(!empty($remember)) {
                    setcookie ("rememberMeId", $data['username'], time()+ (10 * 365 * 24 * 60 * 60),"/");  
                    setcookie ("rememberMePass", $data['password'],  time()+ (10 * 365 * 24 * 60 * 60),"/");
				} else {
                    setcookie ("rememberMeId",""); 
					setcookie ("rememberMePass","");
				} 
				// $error = $_COOKIE['rememberMeId'];
				// echo $error;
				// exit;
				$error = '';
			}else
			{
				$error = $return['error'];
			}
			if(isset($return['default_menu_url']))
			{
				$result['url'] = $return['default_menu_url'];
			}
		}
		$result['error_msg'] = $error;
		echo json_encode($result);
    }
    
    function signout()
    {
		// $this->authorization->logout();
		$this->session->sess_destroy();
        redirect(site_url());
    }

}
