<div class="table-responsive ">
    <table id="listDataTableProcess" class="table table-striped table-bordered table-hover" style="width:100%;">
        <thead>
            <tr>
                <th style="vertical-align:middle; text-align:center;">Nomor</th>
                <th style="vertical-align:middle; text-align:center;">Tanggal</th>
                <th style="vertical-align:middle; text-align:center;">Vendor</th>
                <th style="vertical-align:middle; text-align:center;">ID Kendaraan</th>
                <th style="vertical-align:middle; text-align:center;">Nomor Kendaraan</th>
                <th style="vertical-align:middle; text-align:center;">Berat Kotor</th>
                <th style="vertical-align:middle; text-align:center;">Berat Kosong</th>
                <th style="vertical-align:middle; text-align:center;">Berat Bersih</th>
                <th style="vertical-align:middle; text-align:center;">Status</th>
            </tr>
        </thead>
    </table>
</div>

<script>
	$(document).ready(function() {
		$('#form_filter_process').submit(function(e) {
			refreshDataTableProcess(true);
			e.preventDefault();
		});

		var listDataTableProcess = $('#listDataTableProcess')
			.on('preXhr.dt', function(e, settings, data) {
				// $('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'ordering': true,
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "mining_recap/listPageProcess",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.filter_date_start = $('#filter_date_start_process').val(),
						d.filter_date_end = $('#filter_date_end_process').val(),
						d.filter_vendor = $('#filter_vendor_process').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						// $('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [
					// {
					// 	"render": function(data, type, row) {
					// 		return getViewButton(row['hauling_number']);
					// 	},
					// 	"targets": 0,
					// 	"orderable": true
					// },
                    {
						"render": function(data, type, row) {
							var res = format_date(row['mine_date']);
							return res;
						},
						"targets": 1,
						// "width": "7%",
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['vendor_id']?(row['vendor_id']+' - '+row['vendor_name']):'-';
						},
						"targets": 2,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							return row['vehicle_id']?row['vehicle_id']:'-';
						},
						"targets": 3,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							return row['vehicle_number']?row['vehicle_number']:'-';
						},
						"targets": 4,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['gross_weight'],2);
						},
						"className": 'text-right',
						"targets": 5,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['tare_weight'],2);
						},
						"className": 'text-right',
						"targets": 6,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['net_weight'],2);
						},
						"className": 'text-right',
						"targets": 7,
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['status']?row['status']:'-';
						},
						"targets": 8,
						"orderable": true
					}
				],
				'columns': [{
						data: 'mine_number'
					},
					{
						data: 'mine_date'
					},
					{
						data: 'vendor_id'
					},
					{
						data: 'vehicle_id'
					},
					{
						data: 'vehicle_number'
					},
					{
						data: 'gross_weight'
					},
					{
						data: 'tare_weight'
					},
					{
						data: 'net_weight'
					},
					{
						data: 'status'
					},
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					// $('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
						extend: 'copy'
					},
					
				],
			});
			

		$('.exportExcelBtn').hide();
		new $.fn.dataTable.Buttons(listDataTableProcess, {
			buttons: [{
				text: '<i class="fa fa-file-excel-o"></i> Export Excel',
				extend: 'excel',
				className: ' btn_modules_3 pull-left exportExcelBtn btn-xs btn-skin btn-primary',
				extension: '.xlsx'
			}]
		});
		// Add the Print button to the toolbox
		listDataTableProcess.buttons(1, null).container().appendTo('.ibox-tools');
		$(".exportExcelBtn").removeClass("btn-default");
		$(".dt-buttons").addClass("pd-4");
		$(".dt-buttons").addClass("pull-left");
	});

	function refreshDataTableProcess($reset_page = false) {
		$('#listDataTableProcess').DataTable().ajax.reload(null, $reset_page);
	}
</script>