<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox">
				
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a type="button" class="btn btn_modules_1 loadingButton pull-right btn-xs btn-skin btn-success" href="<?=base_url(uri_string())?>/input/'+000"><i class="fa fa-plus-circle"></i> Create New</a> 
                </div>
            </div>

				<div class="ibox-content">
					<div class="clients-list">

						<div class="table-responsive ">
							<table id="clientDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
								<thead>
									<tr>
										<th>Vehicle Id</th>
										<th>Vehicle Number</th>
										<th>Vendor Card</th>
										<th>Vendor Subcon</th>
										<th>Default Weight</th>
										<th>Tare Weight</th>
										<th>Fuel Convertion</th>
									</tr>
								</thead>
							</table>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$('#clientDataTable').DataTable({
			'processing': true,
			'serverSide': true,
			'serverMethod': 'post',
			'ajax': {
				'url': site_url + "master/vehicle/listPage",
				'data': function(d) {}
			},
			"columnDefs": [{
					"render": function(data, type, row) {
						return getViewButton(row['vehicle_id']);
					},
					"targets": 0,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						return row['vendor_id']?(row['vendor_id']+' - '+row['vendor_name']):'-';
					},
					"targets": 2,
					"orderable": true
				},
			],
			'columns': [{
					data: 'vehicle_id'
				},
				{
					data: 'vehicle_number'
				},
				{
					data: 'vendor_id'
				},
				{
					data: 'vendor_subcon'
				},
				{
					data: 'default_weight'
				},
				{
					data: 'tare_weight'
				},
				{
					data: 'fuel_convertion'
				}
			],
			initComplete: function() {},
		});

	});

	function getViewButton(vehicle_id) {
		return '<a data-style="zoom-in" type="button" class="btn btn_modules_10 btn-xs loadingButton" href="<?= base_url(uri_string()) ?>/input/' + encode(vehicle_id) + '">' + vehicle_id + '</a>'
	}

	function refreshDataTable() {
		$('#clientDataTable').DataTable().ajax.reload(null, false);
	}
</script>