<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coal_getting_recap extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coal_getting_model');
		$this->load->model('coal_getting_recap_model');
		$this->bc->set_title('Coal Getting Recap');
		$this->bc->add('Coal Getting',base_url().'coalgetting');
		$this->bc->add('Recap',base_url().'coalgetting/coal_getting_recap');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'recap/main'
		);
		$this->load->view('tpl',$data);
	}

    public function load_coalget_process()
	{
		
		$data = array(
			'content' => 'recap/process',
		);
		$this->load->view($data['content'], $data);
	}

	public function load_coalget_report()
	{
		
		$data = array(
			'content' => 'recap/report',
		);
		$this->load->view($data['content'], $data);
	}

    public function listPageProcess()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('filter_vendor');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor){
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$where["(
			tbl.coal_get_number LIKE '%$searchValue%'
			OR tbl.vehicle_id LIKE '%$searchValue%'
			OR tbl.vehicle_number LIKE '%$searchValue%'
			OR sts.status LIKE '%$searchValue%'
		)"] = NULL;

		$this->coal_getting_model->set_where($where);
		
		$list_count = $this->coal_getting_model->count();
		$this->coal_getting_model->set_limit($rowperpage);
		$this->coal_getting_model->set_offset($start);
		$this->coal_getting_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->coal_getting_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

    public function listPageReport()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('filter_vendor');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_recapdate >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_recapdate <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor){
			$where['tbl.vendor_id'] = $filter_vendor;
		}
		
		$where["(
			tbl.coal_get_recapnum LIKE '%$searchValue%'
			OR tbl.coal_get_number LIKE '%$searchValue%'
            OR sts.status LIKE '%$searchValue%'
		)"] = NULL;

		$this->coal_getting_recap_model->set_where($where);
		
		$list_count = $this->coal_getting_recap_model->count();
		$this->coal_getting_recap_model->set_limit($rowperpage);
		$this->coal_getting_recap_model->set_offset($start);
		$this->coal_getting_recap_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->coal_getting_recap_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}
}