<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>mineSeal | Reset Password</title>

    <link href="<?= base_url() ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/css/animate.css" rel="stylesheet">
    <link href="<?= base_url() ?>assets/css/style.css" rel="stylesheet">

	<!-- Ladda style -->
	<link href="<?= base_url() ?>assets/css/plugins/ladda/ladda-themeless.min.css" rel="stylesheet">
	<!-- Sweet Alert -->
	<link href="<?= base_url() ?>assets/css/plugins/sweetalert/sweetalert.css" rel="stylesheet">
	<link href="<?= base_url() ?>assets/css/plugins/iCheck/custom.css" rel="stylesheet">
</head>

<body class="gray-bg">

    <div class="middle-box text-center loginscreen   animated fadeInDown">
        <div>
            <h3>Reset Password</h3>
            <?php 
            if ($error){
                ?>
                <p class="text-danger"><?= $error ?></p>
                <?php
            }else{?>
            <p>Silahkan atur ulang password anda</p>
            <form class="m-t" role="form" id="formMyPassword">
                <input hidden type="text" value=<?= $token ?> name="tToken">
                <div class="form-group">
                    <input type="text" class="form-control" placeholder="Name" required="" value=<?= $opr['userName']?> readonly>
                </div>
                <div class="form-group">
                    <input type="email" class="form-control" placeholder="Email" required="" value=<?= $opr['email']?> readonly>
                </div>
                <div class="form-group">
                    <input type="password" class="form-control" name="tPassword" placeholder="Password" required="">
                </div>
                <div class="form-group">
                    <input type="password" class="form-control" name="tReTypePassword" placeholder="ReType Password" required="">
                </div>
                <button type="button" class="btn btn-primary block full-width m-b" onClick="resetMyPassword()" id="resetButton">Reset Password</button>
            </form>
            <?php }?>
            <p class="m-t"> <strong>Copyright</strong> &copy; <?=date('Y')?> <?=get_myconf('dev_team')?></p>
        </div>
    </div>

    <!-- Mainly scripts -->
    <script src="<?= base_url() ?>assets/js/jquery-3.1.1.min.js"></script>
    <script src="<?= base_url() ?>assets/js/bootstrap.min.js"></script>
    <!-- Ladda -->
    <script src="<?= base_url() ?>assets/js/plugins/ladda/spin.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.min.js"></script>
	<script src="<?= base_url() ?>assets/js/plugins/ladda/ladda.jquery.min.js"></script>

    <!-- Sweet alert -->
    <script src="<?= base_url() ?>assets/js/plugins/sweetalert/sweetalert.min.js"></script>
    <script>
        $(document).ready(function(){
            $('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        });
        function resetMyPassword(e) {
            var l = $('#resetButton').ladda();
            l.ladda('start');
            $.ajax({
                type: "POST",
                url: "<?= base_url('login/forgot/reset')?>",
                data: $("#formMyPassword").serialize(),
                dataType: 'json',
                success: function(response) {
                    console.log(response);
                    if (response['error_msg']) {
                        swal(response['header'] || 'error', response['error_msg'] || '', "error");
                        l.ladda('stop');
                    } else {
                        // alert('berhasil');
                        window.location = "<?= base_url('login')?>";
                    }
                },
                error: function(jqXhr, textStatus, errorThrown) {
                    // console.log((textStatus));
                    l.ladda('stop');
                    swal('error', 'please reload the page', "error");
                }
            });
        }
    </script>
</body>

</html>
