<!DOCTYPE html>
<html>

<head>
    <link href="<?=base_url()?>assets/css/print-doc-html.css" rel="stylesheet">
    <title>Hauling Report Print</title>
</head>
<body>
<div class="container">
    <h3 class="text-center">Hauling Report</h3>
    <div class="row">
        <div class="col-6">
            <table style="width:100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="text-left" style="width: 20%;">Vendor</td>
                    <td class="text-left" style="width: 30%;">: <?=$data_hauling_recap['vendor_mis']?> - <?=$data_hauling_recap['vendor_name']?></td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Ongkos</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['ongkos'])?> / Tons</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Biaya Selisih</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['biaya_selisih'])?> / Tons</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Start</td>
                    <td class="text-left" style="width: 30%;">: <?= humanize_mdate($start_date) ?></td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">End</td>
                    <td class="text-left" style="width: 30%;">: <?= humanize_mdate($end_date) ?></td>
                </tr>
            </table>
        </div>
        <div class="col-6">
            <table style="width:100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="text-left" style="width: 20%;">Total Trafict</td>
                    <td class="text-left" style="width: 30%;">: <?=number_format($count_hauling)?> </td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Total Berat Bersih</td>
                    <td class="text-left" style="width: 30%;">: <?=number_format($data_hauling_recap['net_weight'],2)?> Tons / Rp. <?=number_format($data_hauling_recap['net_weight'] * $data_hauling_recap['ongkos'])?></td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Total Selisih Berat</td>
                    <td class="text-left" style="width: 30%;">: 0</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Selisih harus diganti</td>
                    <td class="text-left" style="width: 30%;">: 0 Tons / Rp. 0</td>
                </tr>
                <tr>
                    <td class="text-left" style="width: 20%;">Total Tagihan</td>
                    <td class="text-left" style="width: 30%;">: Rp. <?=number_format($data_hauling_recap['net_weight'] * $data_hauling_recap['ongkos'])?></td>
                </tr>
            </table>
        </div>
    </div> <br>
    <div class="row">
        <div class="col-12">
            <table style="width:100%" cellspacing="0" cellpadding="0">
            <thead>
                <tr style="text-align:center">
                    <th rowspan="2">#Trafict</th>
                    <th rowspan="2">Nomor Hauling</th>
                    <th colspan="2">Kendaraan</th>
                    <th colspan="3">Berangkat</th>
                    <th colspan="3">Tiba di Jeti</th>
                    <th rowspan="2">Total Waktu</th>
                    <th rowspan="2">Selisih Berat Bersih</th>
                </tr>
                <tr style="text-align:center">
                    <th>ID</th>
                    <th>No. Polisi</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                    <th>Tanggal</th>
                    <th>Waktu</th>
                    <th>Berat Bersih</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($data_hauling->num_rows() > 0) {
                    $i = 0;
                    foreach ($data_hauling->result_array() as $row) {
                        $i++;
                ?>
                        <tr>
                            <td class="bordered" style="text-align:center"><?= $i ?></td>
                            <td class="bordered" style="text-align:left"><?= $row['hauling_number'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['vehicle_id'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['vehicle_number'] ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row['hauling_out_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['hauling_out_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row['net_weight'],2) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= humanize_mdate($row['hauling_date']) ?></td>                    
                            <td class="bordered" style="text-align:center"><?= $row['hauling_time'] ?></td>                    
                            <td class="bordered" style="text-align:right"><?= number_format($row['net_weight'],2) ?></td>         
                            
                            <?php 
                                $date1 = strtotime($row['hauling_out_date'] .' '. $row['hauling_out_time']) ;
                                $fromdate = date('Y-m-d H:m:s',$date1);

                                $date2 = strtotime($row['hauling_date'] .' '. $row['hauling_time']) ;
                                $untildate = date('Y-m-d H:m:s',$date2);

                                $d1 = new DateTime($fromdate);
                                $d2 = new DateTime($untildate);
                                $interval = $d2->diff($d1);
                                // echo $interval->format('%d days, %H hours, %I minutes, %S seconds');
                            ?>

                            <td class="bordered" style="text-align:center"><?= $interval->format('%d hari, %H jam') ?></td>                    
                            <td class="bordered" style="text-align:right"> 0 </td>                    
                        </tr>
                    <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td class="bordered" colspan="12"><i>Data Tidak Ditemukan</i></td>
                    </tr>
                <?php } ?>
            </tbody>
            </table>
        </div>
    </div>
</div>    
</body>
</html>
<style>
    @page {
        margin: 20px 40px 20px 40px !important;
    }
    table{
        border: none;
        border-collapse: collapse;
    }

    th {
        font-weight: normal;
        font-size: 15px;
    }

    td {
        border: none;
        font-size: 15px;
    }

    td.bordered {
        border-bottom: 1px solid #CCC;
        border-top: 1px solid #CCC;
        border-left: 1px solid #CCC;
        border-right: 1px solid #CCC;
        font-size: 12px;
    }

</style>