<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


function autoReconsileCash($row_id_bank_reconsile, $id_bank_statement = 0, $id_operator = 0)
{
	// jika $id_bank_statement di isi maka manual reconsile else akan cari dengan nominal yang sama
	$query_list = array();
	$error				= '';
	$is_processed = false;
	$CI = &get_instance();
	$CI->load->model('finance/bank_reconsile_model');
	$CI->load->model('finance/bank_reconsile_detail_model');
	$CI->load->model('finance/bank_deposit_model');
	$CI->load->model('finance/bank_statement_model');
	$CI->load->model('finance/bank_cash_in_model');
	$CI->load->model('finance/bank_cash_in_detail_model');
	$CI->load->model('master/bank_cash_account_model');
	$CI->load->model('master/coa_model');
	$CI->load->model('master/journal_all_model');
	$row = array();
	if (is_array($row_id_bank_reconsile)) {
		$row = $row_id_bank_reconsile;
	} else {
		$row = $CI->bank_reconsile_detail_model->get($row_id_bank_reconsile);
	}

	$whr_update_reconsile = array();
	$whr_update_reconsile['storeCode'] = $row['storeCode'];
	$whr_update_reconsile['transDate'] = $row['transDate'];
	$whr_update_reconsile['businessUnitCode'] = $row['businessUnitCode'];

	$get_bank_reconsile = $CI->bank_reconsile_model->get($whr_update_reconsile);

	$accountNumberDeposit = $row['accountNumberDeposit'];
	$transDateDeposit = $row['transDateDeposit'];
	$amountSystem = $row['amountSystem'];

	$newTransdateDesposit = date('Y-m-d', strtotime($transDateDeposit . ' + 5 days'));

	$data_update_reconsile_detail = array();
	$data_process_reconsile_detail = array();
	$CI->db->trans_start();
	if ($get_bank_reconsile['storeCode'] != '') {
		$get_bank_statement = array();
		if ($id_bank_statement) {
			// start job
			$get_bank_statement = $CI->bank_statement_model->get(array('idBankStatement' => $id_bank_statement));
			// update bank reconsile detail
			$data_process_reconsile_detail['fidBankStatement'] = $get_bank_statement['idBankStatement'];
			$data_process_reconsile_detail['bankCode'] = $get_bank_statement['bankCode'];
			$data_process_reconsile_detail['transDateBS'] = $get_bank_statement['transDate'];
			$data_process_reconsile_detail['accountNumberBS'] = $get_bank_statement['accountNumber'];
			$data_process_reconsile_detail['accountNameBS'] = $get_bank_statement['accountName'];
			$data_process_reconsile_detail['amountBS'] = $get_bank_statement['amount'];
			$data_process_reconsile_detail['descriptionBS'] = $get_bank_statement['description'];
			$data_process_reconsile_detail['verifiedBy'] = $id_operator;
			$data_process_reconsile_detail['postedBy'] = $id_operator;
			$data_process_reconsile_detail['postedDate'] = date('Y-m-d H:i:s');
			$data_process_reconsile_detail['tranStatus'] = 1;
			$data_process_reconsile_detail['verifiedDate'] = date('Y-m-d H:i:s');
		} else {
			$where_bank_statement = array();
			$where_bank_statement['(transDate >= ' . quotedStr($transDateDeposit) . ' AND transDate <= ' . quotedstr($newTransdateDesposit) . ')'] = null;
			$where_bank_statement['accountNumber'] = $accountNumberDeposit;
			$where_bank_statement['amount'] = $amountSystem;
			$where_bank_statement['("refTransaction" IS NULL OR "refTransaction" = \'\') '] = null;
			$whr[] = $where_bank_statement;
			$get_bank_statement = $CI->bank_statement_model->get($where_bank_statement);
			if ($get_bank_statement['idBankStatement'] != '') {
				// update bank reconsile detail
				$data_process_reconsile_detail['fidBankStatement'] = $get_bank_statement['idBankStatement'];
				$data_process_reconsile_detail['bankCode'] = $get_bank_statement['bankCode'];
				$data_process_reconsile_detail['transDateBS'] = $get_bank_statement['transDate'];
				$data_process_reconsile_detail['accountNumberBS'] = $get_bank_statement['accountNumber'];
				$data_process_reconsile_detail['accountNameBS'] = $get_bank_statement['accountName'];
				$data_process_reconsile_detail['amountBS'] = $get_bank_statement['amount'];
				$data_process_reconsile_detail['descriptionBS'] = $get_bank_statement['description'];
				$data_process_reconsile_detail['verifiedBy'] = $id_operator;
				$data_process_reconsile_detail['postedBy'] = $id_operator;
				$data_process_reconsile_detail['postedDate'] = date('Y-m-d H:i:s');
				$data_process_reconsile_detail['tranStatus'] = 1;
				$data_process_reconsile_detail['verifiedDate'] = date('Y-m-d H:i:s');
			}
		}
		// update bank statement
		if (isset($get_bank_statement['idBankStatement'])) {
			if ($get_bank_statement['idBankStatement'] != '') {
				// insert bank cash in
				// get ke bank cash account
				$bankCashAccount = $CI->bank_cash_account_model->get(array('bankAccountNum' => $get_bank_statement['accountNumber']));
				$bankCashBankAccountCode = $bankCashAccount['bankAccountCode'];
				$bankCashAccountCode = $bankCashAccount['accountCode'];
				$bankCashAccountCategory = $bankCashAccount['bankAccountCategory'];
				$coa = $CI->coa_model->get(array('accountCode' => $bankCashAccountCode));
				$bankCashAccountName = $coa['accountName'];

				if ($bankCashBankAccountCode) {
					$prefix = $row['businessUnitCode'] . '/' . date('y') . date('m') . "/" . $bankCashBankAccountCode . ($bankCashAccountCategory == "Bank" ? '/BM' : "/KM");
					$data['transNum'] 				= $CI->bank_cash_in_model->gen_transaction_number($prefix);
					$data['createdDate']			= date('Y-m-d H:i:s');
					$data['businessUnitCode']	 = $row['businessUnitCode'];
					$data['deptCode']					 = 'SSO';
					$data['refNum']						 = $row['transNum'];
					$data['transDate']				 = $get_bank_statement['transDate'];
					$data['bankAccountCode']	 = $bankCashBankAccountCode;
					$data['currency']					 = 'IDR';
					$data['receiptFrom']			 = $row['storeCode'];
					$data['isDropping']				 = 0;
					$data['description']			 = $get_bank_statement['description'];
					$data['total']						 = $get_bank_statement['amount'];
					$data['tranStatus']				 = 3;
					$data['createdBy']				 = $id_operator;
					$data['createdDate']			 = date('Y-m-d H:i:s');
					// $data['modifBy']					 = '';		
					// $data['modifDate']				 = '';			
					$data['approvedBy']				 = $id_operator;
					$data['approvedDate']			 = date('Y-m-d H:i:s');
					$data['approvedStatus']		 = 'Y';
					$data['lastUpdate']				 = date('Y-m-d H:i:s');
					// $data['trxType']					 = 0;
					$data['currencyRate']			 = 1;

					$arrCoaCategory = getCoaCategory('StoreRcv', $data['businessUnitCode']);

					$data_detail = array();
					$data_detail['recNum']						= 1;
					$data_detail['transNum']					= $data['transNum'];
					$data_detail['description']				= $data['description'];
					$data_detail['accountCode']				= $arrCoaCategory['accountCode'];
					$data_detail['accountName']				= $arrCoaCategory['accountName'];
					$data_detail['amount']						= $data['total'];
					$data_detail['businessUnitCode']	= $data['businessUnitCode'];
					$data_detail['deptCode']					= $data['deptCode'];
					$data_detail['tranStatus']				= $data['tranStatus'];
					$data_detail['createdBy']					= $data['createdBy'];
					$data_detail['createdDate']				= $data['createdDate'];
					// $data_detail['modifBy']						= '';
					// $data_detail['modifDate']					= '';

					$save_bank_cash_in = $CI->bank_cash_in_model->save($data);
					$query_list[] = '_' . $CI->bank_cash_in_model->last_query . '===';
					$save_bank_cash_in_detail = $CI->bank_cash_in_detail_model->save($data_detail);
					$query_list[] = '_' . $CI->bank_cash_in_detail_model->last_query . '===';
					// insert journal
					$data_journal_temp = array();
					$data_journal = array();
					$currency_rate = 1;
					$data_journal_temp['transNum'] 					= $data['transNum'];
					$data_journal_temp['businessUnitCode'] = $row['businessUnitCode'];
					$data_journal_temp['dateJournal'] 			= $data['transDate'];
					$data_journal_temp['note'] 							= $data['description'];
					$data_journal_temp['idJournal'] 				= 36;
					$data_journal_temp['currencyRate'] 			= $currency_rate;
					// $data_journal_temp['subId'] 						= ''; 
					$data_journal_temp['allocation'] 				= $row['storeCode'];
					$data_journal_temp['businessPartnerCode'] = $row['storeCode'];
					$data_journal_temp['currency'] 					= 'IDR';
					// $data_journal['projectNum'] 				= '';
					$data_journal_temp['deptCode'] 					= $data['deptCode'];
					// debet
					$data_journal_temp['debetFgCurr'] 			= $data['total'];
					$data_journal_temp['creditFgCurr'] 			= 0;
					$data_journal_temp['debet'] 						= $data['total'];
					$data_journal_temp['credit'] 						= 0;
					$data_journal_temp['accountCode'] 			= $bankCashAccountCode;
					$data_journal_temp['accountName'] 			= $bankCashAccountName;
					$data_journal_temp['bankAccountCode'] 	= $data['bankAccountCode'];
					$data_journal[] 				= $data_journal_temp;

					// credit
					$data_journal_temp['debetFgCurr'] 			= 0;
					$data_journal_temp['creditFgCurr'] 			= $data['total'];
					$data_journal_temp['debet'] 						= 0;
					$data_journal_temp['credit'] 						= $data['total'];
					$data_journal_temp['accountCode'] 			= $arrCoaCategory['accountCode'];
					$data_journal_temp['accountName'] 			= $arrCoaCategory['accountName'];
					$data_journal_temp['bankAccountCode'] 	= '';

					$data_journal[] 				= $data_journal_temp;

					$CI->journal_all_model->delete(array('transNum' => $data_journal_temp['transNum']));
					$CI->db->insert_batch('facc.journalAll', $data_journal);
					$query_list[] = '_' . $CI->db->last_query() . '===';
					$data_update_bank = array();
					$data_update_bank['idBankStatement'] = $get_bank_statement['idBankStatement'];
					$data_update_bank['refTransaction'] = $row['transNum'];
					$CI->bank_statement_model->save($data_update_bank);
					$query_list[] = '_' . $CI->bank_statement_model->last_query . '===';
					$data_process_reconsile_detail['transNumJournal'] = $data['transNum'];
				} else {
					$error .= ' [Account Number ' . $get_bank_statement['accountNumber'] . ' tidak ditemukan di bankCashAccount]';
				}
			} else {
				$error .= ' [Bank Statement tidak ditemukan]';
			}
		}
		// finish job
		$CI->bank_reconsile_detail_model->save(array('idBankReconsileDetail' => $row['idBankReconsileDetail'], 'updateTime' => date('Y-m-d H:i:s')));
		$error = trim($error);
		if ($error == '') {
			$is_processed = true;
			$data_update_reconsile_detail = $data_process_reconsile_detail;
			$data_update_reconsile_detail['processTime'] = date('Y-m-d H:i:s');
		}
	} else {
		$error .= ' [Header bank reconsile tidak ditemukan]';
	}
	$data_update_reconsile_detail['idBankReconsileDetail'] = $row['idBankReconsileDetail'];
	$data_update_reconsile_detail['lastCheck'] = date('Y-m-d H:i:s');

	// update reconsile detail
	$CI->bank_reconsile_detail_model->save($data_update_reconsile_detail);
	$query_list[] = '_' . $CI->bank_reconsile_detail_model->last_query . '===';

	if ($CI->db->trans_status() === false) {
		$CI->db->trans_rollback();
		$error = $CI->db->error();
		error($error);
	} else {
		$CI->db->trans_commit();
	}

	$result = array();
	$result['is_processed'] = $is_processed;
	$result['query_list'] = $query_list;
	$result['error'] = $error;

	updateStatusCashDeposit($row['idBankReconsileDetail'], $id_operator);

	$query_list[] = '_' . $CI->db->last_query() . '===';

	return $result;
}

function autoReconsileTransfer($row_id_bank_reconsile, $id_bank_statement = 0, $id_operator = 0)
{
	// jika $id_bank_statement di isi maka manual reconsile else akan cari dengan nominal yang sama
	$query_list = array();
	$error				= '';
	$is_processed = false;
	$CI = &get_instance();
	$CI->load->model('finance/bank_reconsile_model');
	$CI->load->model('finance/bank_reconsile_detail_model');
	$CI->load->model('finance/bank_deposit_model');
	$CI->load->model('finance/bank_statement_model');
	$CI->load->model('finance/bank_cash_in_model');
	$CI->load->model('finance/bank_cash_in_detail_model');
	$CI->load->model('master/bank_cash_account_model');
	$CI->load->model('master/coa_model');
	$CI->load->model('master/journal_all_model');
	$row = array();
	if (is_array($row_id_bank_reconsile)) {
		$row = $row_id_bank_reconsile;
	} else {
		$row = $CI->bank_reconsile_detail_model->get($row_id_bank_reconsile);
	}

	$whr_update_reconsile = array();
	$whr_update_reconsile['storeCode'] = $row['storeCode'];
	$whr_update_reconsile['transDate'] = $row['transDate'];
	$whr_update_reconsile['businessUnitCode'] = $row['businessUnitCode'];

	$get_bank_reconsile = $CI->bank_reconsile_model->get($whr_update_reconsile);

	// $accountNumberDeposit = $row['accountNumberDeposit'];
	$transDateDeposit = $row['transDate'];
	$amountSystem = $row['amountSystem'];

	$newTransdateDesposit = date('Y-m-d', strtotime($transDateDeposit . ' + 5 days'));

	$data_update_reconsile_detail = array();
	$data_process_reconsile_detail = array();
	$CI->db->trans_start();
	if ($get_bank_reconsile['storeCode'] != '') {
		$get_bank_statement = array();
		if ($id_bank_statement) {
			// start job
			$get_bank_statement = $CI->bank_statement_model->get(array('idBankStatement' => $id_bank_statement));
			// update bank reconsile detail
			$data_process_reconsile_detail['fidBankStatement'] = $get_bank_statement['idBankStatement'];
			$data_process_reconsile_detail['bankCode'] = $get_bank_statement['bankCode'];
			$data_process_reconsile_detail['transDateBS'] = $get_bank_statement['transDate'];
			$data_process_reconsile_detail['accountNumberBS'] = $get_bank_statement['accountNumber'];
			$data_process_reconsile_detail['accountNameBS'] = $get_bank_statement['accountName'];
			$data_process_reconsile_detail['amountBS'] = $get_bank_statement['amount'];
			$data_process_reconsile_detail['descriptionBS'] = $get_bank_statement['description'];
			$data_process_reconsile_detail['verifiedBy'] = $id_operator;
			$data_process_reconsile_detail['postedBy'] = $id_operator;
			$data_process_reconsile_detail['postedDate'] = date('Y-m-d H:i:s');
			$data_process_reconsile_detail['tranStatus'] = 1;
			$data_process_reconsile_detail['verifiedDate'] = date('Y-m-d H:i:s');
		} else {
			$where_bank_statement = array();
			$where_bank_statement['(transDate >= ' . quotedStr($transDateDeposit) . ' AND transDate <= ' . quotedstr($newTransdateDesposit) . ')'] = null;
			// $where_bank_statement['accountNumber'] = $accountNumberDeposit;
			$where_bank_statement['amount'] = $amountSystem;
			$where_bank_statement['("refTransaction" IS NULL OR "refTransaction" = \'\') '] = null;
			$whr[] = $where_bank_statement;
			$get_bank_statement = $CI->bank_statement_model->get($where_bank_statement);
			if ($get_bank_statement['idBankStatement'] != '') {
				// update bank reconsile detail
				$data_process_reconsile_detail['fidBankStatement'] = $get_bank_statement['idBankStatement'];
				$data_process_reconsile_detail['bankCode'] = $get_bank_statement['bankCode'];
				$data_process_reconsile_detail['transDateBS'] = $get_bank_statement['transDate'];
				$data_process_reconsile_detail['accountNumberBS'] = $get_bank_statement['accountNumber'];
				$data_process_reconsile_detail['accountNameBS'] = $get_bank_statement['accountName'];
				$data_process_reconsile_detail['amountBS'] = $get_bank_statement['amount'];
				$data_process_reconsile_detail['descriptionBS'] = $get_bank_statement['description'];
				$data_process_reconsile_detail['verifiedBy'] = $id_operator;
				$data_process_reconsile_detail['postedBy'] = $id_operator;
				$data_process_reconsile_detail['postedDate'] = date('Y-m-d H:i:s');
				$data_process_reconsile_detail['tranStatus'] = 1;
				$data_process_reconsile_detail['verifiedDate'] = date('Y-m-d H:i:s');
			}
		}
		// update bank statement
		if (isset($get_bank_statement['idBankStatement'])) {
			if ($get_bank_statement['idBankStatement'] != '') {
				// insert bank cash in
				// get ke bank cash account
				$bankCashAccount = $CI->bank_cash_account_model->get(array('bankAccountNum' => $get_bank_statement['accountNumber'], 'businessUnitCode' => $row['businessUnitCode']));
				$bankCashBankAccountCode = $bankCashAccount['bankAccountCode'];
				$bankCashAccountCode = $bankCashAccount['accountCode'];
				$bankCashAccountCategory = $bankCashAccount['bankAccountCategory'];
				$coa = $CI->coa_model->get(array('accountCode' => $bankCashAccountCode));
				$bankCashAccountName = $coa['accountName'];

				if ($bankCashBankAccountCode) {
					$prefix = $row['businessUnitCode'] . '/' . date('y') . date('m') . "/" . $bankCashBankAccountCode . ($bankCashAccountCategory == "Bank" ? '/BM' : "/KM");
					$data['transNum'] 				= $CI->bank_cash_in_model->gen_transaction_number($prefix);
					$data['createdDate']			= date('Y-m-d H:i:s');
					$data['businessUnitCode']	 = $row['businessUnitCode'];
					$data['deptCode']					 = 'SSO';
					$data['refNum']						 = $row['transNum'];
					$data['transDate']				 = $get_bank_statement['transDate'];
					$data['bankAccountCode']	 = $bankCashBankAccountCode;
					$data['currency']					 = 'IDR';
					$data['receiptFrom']			 = $row['storeCode'];
					$data['isDropping']				 = 0;
					$data['description']			 = $get_bank_statement['description'];
					$data['total']						 = $get_bank_statement['amount'];
					$data['tranStatus']				 = 3;
					$data['createdBy']				 = $id_operator;
					$data['createdDate']			 = date('Y-m-d H:i:s');
					// $data['modifBy']					 = '';		
					// $data['modifDate']				 = '';			
					$data['approvedBy']				 = $id_operator;
					$data['approvedDate']			 = date('Y-m-d H:i:s');
					$data['approvedStatus']		 = 'Y';
					$data['lastUpdate']				 = date('Y-m-d H:i:s');
					// $data['trxType']					 = 0;
					$data['currencyRate']			 = 1;

					$arrCoaCategory = getCoaCategory('StoreRcv', $data['businessUnitCode']);

					$data_detail = array();
					$data_detail['recNum']						= 1;
					$data_detail['transNum']					= $data['transNum'];
					$data_detail['description']				= $data['description'];
					$data_detail['accountCode']				= $arrCoaCategory['accountCode'];
					$data_detail['accountName']				= $arrCoaCategory['accountName'];
					$data_detail['amount']						= $data['total'];
					$data_detail['businessUnitCode']	= $data['businessUnitCode'];
					$data_detail['deptCode']					= $data['deptCode'];
					$data_detail['tranStatus']				= $data['tranStatus'];
					$data_detail['createdBy']					= $data['createdBy'];
					$data_detail['createdDate']				= $data['createdDate'];
					// $data_detail['modifBy']						= '';
					// $data_detail['modifDate']					= '';

					$save_bank_cash_in = $CI->bank_cash_in_model->save($data);
					$query_list[] = '_' . $CI->bank_cash_in_model->last_query . '===';
					$save_bank_cash_in_detail = $CI->bank_cash_in_detail_model->save($data_detail);
					$query_list[] = '_' . $CI->bank_cash_in_detail_model->last_query . '===';
					// insert journal
					$data_journal_temp = array();
					$data_journal = array();
					$currency_rate = 1;
					$data_journal_temp['transNum'] 					= $data['transNum'];
					$data_journal_temp['businessUnitCode'] = $row['businessUnitCode'];
					$data_journal_temp['dateJournal'] 			= $data['transDate'];
					$data_journal_temp['note'] 							= $data['description'];
					$data_journal_temp['idJournal'] 				= 36;
					$data_journal_temp['currencyRate'] 			= $currency_rate;
					// $data_journal_temp['subId'] 						= ''; 
					$data_journal_temp['allocation'] 				= $row['storeCode'];
					$data_journal_temp['businessPartnerCode'] = $row['storeCode'];
					$data_journal_temp['currency'] 					= 'IDR';
					// $data_journal['projectNum'] 				= '';
					$data_journal_temp['deptCode'] 					= $data['deptCode'];
					// debet
					$data_journal_temp['debetFgCurr'] 			= $data['total'];
					$data_journal_temp['creditFgCurr'] 			= 0;
					$data_journal_temp['debet'] 						= $data['total'];
					$data_journal_temp['credit'] 						= 0;
					$data_journal_temp['accountCode'] 			= $bankCashAccountCode;
					$data_journal_temp['accountName'] 			= $bankCashAccountName;
					$data_journal_temp['bankAccountCode'] 	= $data['bankAccountCode'];
					$data_journal[] 				= $data_journal_temp;

					// credit
					$data_journal_temp['debetFgCurr'] 			= 0;
					$data_journal_temp['creditFgCurr'] 			= $data['total'];
					$data_journal_temp['debet'] 						= 0;
					$data_journal_temp['credit'] 						= $data['total'];
					$data_journal_temp['accountCode'] 			= $arrCoaCategory['accountCode'];
					$data_journal_temp['accountName'] 			= $arrCoaCategory['accountName'];
					$data_journal_temp['bankAccountCode'] 	= '';

					$data_journal[] 				= $data_journal_temp;

					$CI->journal_all_model->delete(array('transNum' => $data_journal_temp['transNum']));
					$CI->db->insert_batch('facc.journalAll', $data_journal);
					$query_list[] = '_' . $CI->db->last_query() . '===';
					$data_update_bank = array();
					$data_update_bank['idBankStatement'] = $get_bank_statement['idBankStatement'];
					$data_update_bank['refTransaction'] = $row['transNum'];
					$CI->bank_statement_model->save($data_update_bank);
					$query_list[] = '_' . $CI->bank_statement_model->last_query . '===';
					$data_process_reconsile_detail['transNumJournal'] = $data['transNum'];
				} else {
					$error .= ' [Account Number ' . $get_bank_statement['accountNumber'] . ' [' . $row['businessUnitCode'] . '] tidak ditemukan di bankCashAccount]';
				}
			} else {
				$error .= ' [Bank Statement tidak ditemukan]';
			}
		}
		// finish job
		$CI->bank_reconsile_detail_model->save(array('idBankReconsileDetail' => $row['idBankReconsileDetail'], 'updateTime' => date('Y-m-d H:i:s')));
		$error = trim($error);
		if ($error == '') {
			$is_processed = true;
			$data_update_reconsile_detail = $data_process_reconsile_detail;
			$data_update_reconsile_detail['processTime'] = date('Y-m-d H:i:s');
		}
	} else {
		$error .= ' [Header bank reconsile tidak ditemukan]';
	}
	$data_update_reconsile_detail['idBankReconsileDetail'] = $row['idBankReconsileDetail'];
	$data_update_reconsile_detail['lastCheck'] = date('Y-m-d H:i:s');

	// update reconsile detail
	$CI->bank_reconsile_detail_model->save($data_update_reconsile_detail);
	$query_list[] = '_' . $CI->bank_reconsile_detail_model->last_query . '===';

	if ($CI->db->trans_status() === false) {
		$CI->db->trans_rollback();
		$error = $CI->db->error();
		error($error);
	} else {
		$CI->db->trans_commit();
	}

	$result = array();
	$result['is_processed'] = $is_processed;
	$result['query_list'] = $query_list;
	$result['error'] = $error;

	updateStatusTransferDeposit($row['idBankReconsileDetail'], $id_operator);

	$query_list[] = '_' . $CI->db->last_query() . '===';

	return $result;
}

function autoReconsileEdc($row_id_bank_reconsile, $id_bank_statement = 0, $id_operator = 0)
{
	$query_list = array();
	$error				= '';
	$is_processed = false;
	$CI = &get_instance();

	$CI->load->model('finance/bank_reconsile_detail_model');
	$CI->load->model('master/bank_cash_account_model');
	$CI->load->model('master/coa_model');
	$CI->load->model('master/journal_all_model');
	$CI->load->model('finance/bank_cash_in_model');
	$CI->load->model('finance/bank_cash_in_detail_model');
	$CI->load->model('finance/bank_cash_out_model');
	$CI->load->model('finance/bank_cash_out_detail_model');
	// $id_bank_reconsile = explode(',', $row_id_bank_reconsile);

	$where = array();
	$where['"idBankReconsileDetail" IN (' . $row_id_bank_reconsile . ')'] = null;

	$CI->bank_reconsile_detail_model->set_where($where);
	$list_sum_edc = $CI->bank_reconsile_detail_model->get_sum_amount_edc();

	$row = $list_sum_edc->row_array();

	// update bank statemenet
	// start job
	$get_bank_statement = $CI->bank_statement_model->get(array('idBankStatement' => $id_bank_statement));
	$CI->db->trans_start();
	if (isset($get_bank_statement['idBankStatement'])) {
		if ($get_bank_statement['idBankStatement'] != '') {

			// insert bank cash in
			// get ke bank cash account
			$bankCashAccount = $CI->bank_cash_account_model->get(array('bankAccountNum' => $get_bank_statement['accountNumber'], 'businessUnitCode' => $row['businessUnitCode']));
			$bankCashBankAccountCode = $bankCashAccount['bankAccountCode'];
			$bankCashAccountCode = $bankCashAccount['accountCode'];
			$bankCashAccountCategory = $bankCashAccount['bankAccountCategory'];
			$coa = $CI->coa_model->get(array('accountCode' => $bankCashAccountCode));
			$bankCashAccountName = $coa['accountName'];

			if ($bankCashBankAccountCode) {

				// insert into bank cash in & bank cash in detail
				$prefix = $row['businessUnitCode'] . '/' . date('y') . date('m') . "/" . $bankCashBankAccountCode . ($bankCashAccountCategory == "Bank" ? '/BM' : "/KM");
				$data['transNum'] 				= $CI->bank_cash_in_model->gen_transaction_number($prefix);
				$data['createdDate']			= date('Y-m-d H:i:s');
				$data['businessUnitCode']	 = $row['businessUnitCode'];
				$data['deptCode']					 = 'SSO';
				$data['refNum']						 = $row['transNum'];
				$data['transDate']				 = $get_bank_statement['transDate'];
				$data['bankAccountCode']	 = $bankCashBankAccountCode;
				$data['currency']					 = 'IDR';
				$data['receiptFrom']			 = $row['storeCode'];
				$data['isDropping']				 = 0;
				$data['description']			 = $get_bank_statement['description'];
				$data['total']						 = $row['sum'];
				$data['tranStatus']				 = 3;
				$data['createdBy']				 = $id_operator;
				$data['createdDate']			 = date('Y-m-d H:i:s');
				// $data['modifBy']					 = '';		
				// $data['modifDate']				 = '';			
				$data['approvedBy']				 = $id_operator;
				$data['approvedDate']			 = date('Y-m-d H:i:s');
				$data['approvedStatus']		 = 'Y';
				$data['lastUpdate']				 = date('Y-m-d H:i:s');
				// $data['trxType']					 = 0;
				$data['currencyRate']			 = 1;

				$arrCoaCategory = getCoaCategory('StoreRcv', $data['businessUnitCode']);
				$arrCoaCategoryBco = getCoaCategory('MDRFee', $data['businessUnitCode']);

				$data_detail = array();
				$data_detail['recNum']						= 1;
				$data_detail['transNum']					= $data['transNum'];
				$data_detail['description']				= $data['description'];
				$data_detail['accountCode']				= $arrCoaCategory['accountCode'];
				$data_detail['accountName']				= $arrCoaCategory['accountName'];
				$data_detail['amount']						= $row['sum'];
				$data_detail['businessUnitCode']	= $data['businessUnitCode'];
				$data_detail['deptCode']					= $data['deptCode'];
				$data_detail['tranStatus']				= $data['tranStatus'];
				$data_detail['createdBy']					= $data['createdBy'];
				$data_detail['createdDate']				= $data['createdDate'];
				// $data_detail['modifBy']						= '';
				// $data_detail['modifDate']					= '';
				$save_bank_cash_in = $CI->bank_cash_in_model->save($data);
				
				$data_bk = $data;
				unset($data_bk['receiptFrom']);
				unset($data_bk['isDropping']);
				$data_bk['total']				= $get_bank_statement['amount']-$row['sum'];
				$data_bk['description']	= 'biaya MDR';
				$prefix_bk = $row['businessUnitCode'] . '/' . date('y') . date('m') . "/" . $bankCashBankAccountCode . ($bankCashAccountCategory == "Bank" ? '/BK' : "/KK");
				$data_bk['transNum'] = $CI->bank_cash_out_model->gen_transaction_number($prefix_bk);
				$data_bk['businessPartnerCode']			 = $row['storeCode'];

				$save_bank_cash_out = $CI->bank_cash_out_model->save($data_bk);
				
				$data_detail_bk = $data_detail;
				$data_detail_bk['transNum']					= $data_bk['transNum'];
				$data_detail_bk['accountCode']			= $arrCoaCategoryBco['accountCode'];
				$data_detail_bk['accountName']			= $arrCoaCategoryBco['accountName'];

				$query_list[] = '_' . $CI->bank_cash_in_model->last_query . '===';
				$save_bank_cash_in_detail = $CI->bank_cash_in_detail_model->save($data_detail);
				$query_list[] = '_' . $CI->bank_cash_in_detail_model->last_query . '===';

				$data_detail['amount']						= $get_bank_statement['amount']-$row['sum'];
				$save_bank_cash_out_detail = $CI->bank_cash_out_detail_model->save($data_detail_bk);
				$query_list[] = '_' . $CI->bank_cash_out_detail_model->last_query . '===';
				// insert journal
				$data_journal_temp = array();
				$data_journal = array();
				$data_journal_bco = array();
				$currency_rate = 1;
				$data_journal_temp['transNum'] 					= $data['transNum'];
				$data_journal_temp['businessUnitCode'] = $row['businessUnitCode'];
				$data_journal_temp['dateJournal'] 			= $data['transDate'];
				$data_journal_temp['note'] 							= $data['description'];
				$data_journal_temp['idJournal'] 				= 36;
				$data_journal_temp['currencyRate'] 			= $currency_rate;
				// $data_journal_temp['subId'] 						= ''; 
				$data_journal_temp['allocation'] 				= $row['storeCode'];
				$data_journal_temp['businessPartnerCode'] = $row['storeCode'];
				$data_journal_temp['currency'] 					= 'IDR';
				// $data_journal['projectNum'] 				= '';
				$data_journal_temp['deptCode'] 					= $data['deptCode'];
				// debet
				$data_journal_temp['debetFgCurr'] 			= $row['sum'];
				$data_journal_temp['creditFgCurr'] 			= 0;
				$data_journal_temp['debet'] 						= $row['sum'];
				$data_journal_temp['credit'] 						= 0;
				$data_journal_temp['accountCode'] 			= $bankCashAccountCode;
				$data_journal_temp['accountName'] 			= $bankCashAccountName;
				$data_journal_temp['bankAccountCode'] 	= $data['bankAccountCode'];
				$data_journal[] 				= $data_journal_temp;
				
				// credit
				$data_journal_temp['debetFgCurr'] 			= 0;
				$data_journal_temp['creditFgCurr'] 			= $row['sum'];
				$data_journal_temp['debet'] 						= 0;
				$data_journal_temp['credit'] 						= $row['sum'];
				$data_journal_temp['accountCode'] 			= $arrCoaCategory['accountCode'];
				$data_journal_temp['accountName'] 			= $arrCoaCategory['accountName'];
				$data_journal_temp['bankAccountCode'] 	= '';

				$data_journal[] 				= $data_journal_temp;

				$CI->journal_all_model->delete(array('transNum' => $data_journal_temp['transNum']));
				$CI->db->insert_batch('facc.journalAll', $data_journal);
				$query_list[] = '_' . $CI->db->last_query() . '===';
				
				// insert journal bank out

				$data_journal_temp = array();
				$data_journal = array();
				$currency_rate = 1;
				$data_journal_temp['transNum'] 					= $data_bk['transNum'];
				$data_journal_temp['businessUnitCode'] = $row['businessUnitCode'];
				$data_journal_temp['dateJournal'] 			= $data_bk['transDate'];
				$data_journal_temp['note'] 							= $data_bk['description'];
				$data_journal_temp['idJournal'] 				= 36;
				$data_journal_temp['currencyRate'] 			= $currency_rate;
				// $data_journal_temp['subId'] 						= ''; 
				$data_journal_temp['allocation'] 				= $row['storeCode'];
				$data_journal_temp['businessPartnerCode'] = $row['storeCode'];
				$data_journal_temp['currency'] 					= 'IDR';
				// $data_journal['projectNum'] 				= '';
				$data_journal_temp['deptCode'] 					= $data_bk['deptCode'];
				// debet
				$data_journal_temp['debetFgCurr'] 			= $get_bank_statement['amount']-$row['sum'];
				$data_journal_temp['creditFgCurr'] 			= 0;
				$data_journal_temp['debet'] 						= $get_bank_statement['amount']-$row['sum'];
				$data_journal_temp['credit'] 						= 0;
				$data_journal_temp['accountCode'] 			= $arrCoaCategoryBco['accountCode'];
				$data_journal_temp['accountName'] 			= $arrCoaCategoryBco['accountName'];
				$data_journal_temp['bankAccountCode'] 	= '';
				$data_journal[] 				= $data_journal_temp;
				
				// credit
				$data_journal_temp['debetFgCurr'] 			= 0;
				$data_journal_temp['creditFgCurr'] 			= $get_bank_statement['amount']-$row['sum'];
				$data_journal_temp['debet'] 						= 0;
				$data_journal_temp['credit'] 						= $get_bank_statement['amount']-$row['sum'];
				$data_journal_temp['accountCode'] 			= $bankCashAccountCode;
				$data_journal_temp['accountName'] 			= $bankCashAccountName;
				$data_journal_temp['bankAccountCode'] 	= $data_bk['bankAccountCode'];

				$data_journal[] 				= $data_journal_temp;

				$CI->journal_all_model->delete(array('transNum' => $data_journal_temp['transNum']));
				$CI->db->insert_batch('facc.journalAll', $data_journal);
				$query_list[] = '_' . $CI->db->last_query() . '===';
				
				// update bank statement
				$data_update_bank = array();
				$data_update_bank['idBankStatement'] = $get_bank_statement['idBankStatement'];
				$data_update_bank['refTransaction'] = $row['transNum'];
				$CI->bank_statement_model->save($data_update_bank);
				$query_list[] = '_' . $CI->bank_statement_model->last_query . '===';

				// update bank reconsile detail
				$CI->db->query('
					UPDATE "facc"."bankReconsileDetail" SET 
						"transNumJournal" = ' . quotedstr($data['transNum']) . '
						,"fidBankStatement" = ' . $get_bank_statement['idBankStatement'] . '
						,"bankCode" = ' . quotedstr($get_bank_statement['bankCode']) . '
						,"transDateBS" = ' . quotedstr($get_bank_statement['transDate']) . '
						,"accountNumberBS" = ' . quotedstr($get_bank_statement['accountNumber']) . '
						,"accountNameBS" = ' . quotedstr($get_bank_statement['accountName']) . '
						,"amountBS" = "amountSystem"
						,"descriptionBS" = ' . quotedstr($get_bank_statement['description']) . '
						,"verifiedBy" = ' . $id_operator . '
						,"postedBy" = ' . $id_operator . '
						,"postedDate" = now()
						,"tranStatus" = 1
						,"verifiedDate" = now()
						,"processTime" = now()
						WHERE "idBankReconsileDetail" in (' . $row_id_bank_reconsile . ');
					');
			} else {
				$error .= ' [Account Number ' . $get_bank_statement['accountNumber'] . ' [' . $row['businessUnitCode'] . '] tidak ditemukan di bankCashAccount]';
			}
		} else {
			$error .= ' [Bank Statement tidak ditemukan]';
		}
	}

	// $data_process_reconsile_detail['transNumJournal'] = $data['transNum'];
	// $data_process_reconsile_detail['fidBankStatement'] = $get_bank_statement['idBankStatement'];
	// $data_process_reconsile_detail['bankCode'] = $get_bank_statement['bankCode'];
	// $data_process_reconsile_detail['transDateBS'] = $get_bank_statement['transDate'];
	// $data_process_reconsile_detail['accountNumberBS'] = $get_bank_statement['accountNumber'];
	// $data_process_reconsile_detail['accountNameBS'] = $get_bank_statement['accountName'];
	// $data_process_reconsile_detail['amountBS'] = $get_bank_statement['amount'];
	// $data_process_reconsile_detail['descriptionBS'] = $get_bank_statement['description'];
	// $data_process_reconsile_detail['verifiedBy'] = $id_operator;
	// $data_process_reconsile_detail['postedBy'] = $id_operator;
	// $data_process_reconsile_detail['postedDate'] = date('Y-m-d H:i:s');
	// $data_process_reconsile_detail['tranStatus'] = 1;
	// $data_process_reconsile_detail['verifiedDate'] = date('Y-m-d H:i:s');
	// finish job
	// $CI->bank_reconsile_detail_model->save(array('idBankReconsileDetail' => $row['idBankReconsileDetail'], 'updateTime' => date('Y-m-d H:i:s')));
	$error = trim($error);
	if ($error == '') {
		$is_processed = true;
		// $data_update_reconsile_detail = $data_process_reconsile_detail;
		$data_update_reconsile_detail['processTime'] = date('Y-m-d H:i:s');
	}

	$result = array();
	$result['is_processed'] = $is_processed;
	$result['query_list'] = $query_list;
	$result['error'] = $error;

	// updateStatusTransferDeposit($row['idBankReconsileDetail'], $id_operator);

	$query_list[] = '_' . $CI->db->last_query() . '===';

	if ($CI->db->trans_status() === false) {
		$CI->db->trans_rollback();
		$error = $CI->db->error();
		error($error);
	} else {
		$CI->db->trans_commit();
	}

	$result = array();
	$result['is_processed'] = $is_processed;
	$result['query_list'] = $query_list;
	$result['error'] = $error;

	// updateStatusTransferDeposit($row['idBankReconsileDetail'], $id_operator);

	$query_list[] = '_' . $CI->db->last_query() . '===';

	return $result;
}
