<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
                    <div class="panel-body">
                        <div class="row">
                            <div class="filter-content" style="">
                                <form autocomplete="off" method="post" id="form_filter" class="form-horizontal">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="col-sm-8">
                                                <br>
                                                <div class="form-group" id="daterange">
                                                    <label class="col-sm-2">Tanggal</label>
                                                    <div class="input-daterange input-group col-sm-4" id="datepicker">
                                                        <input id="filter_date_start" type="text" class="input-sm form-control" name="t_filter_date_start" value="01<?= date('-m-Y') ?>" />
                                                        <span class="input-group-addon">to</span>
                                                        <input id="filter_date_end" type="text" class="input-sm form-control" name="t_filter_date_end" value="<?= date('d-m-Y') ?>" />
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2">Vendor</label>
                                                    <div class=" input-group col-sm-4">
                                                        <input type="text" class="form-control" id="filter_vendor" name="t_filter_vendor" value="">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2">Nomor</label>
                                                    <div class=" input-group col-sm-4">
                                                        <input type="text" class="form-control" id="filter_nomor" name="t_filter_nomor" value="">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="col-sm-2">Status</label>
                                                    <div class=" input-group col-sm-4">
                                                        <input type="text" class="form-control" id="filter_status" name="t_filter_status" value="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="row">
                                                    <div class="col-sm-4"><h5>Total Berat Kotor</h5></div>
                                                    <div class="col-sm-1"><h5>:</h5></div>
                                                    <div class="col-sm-3" style="text-align:right;"><h5>999.999.999</h5></div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-4"><h5>Total Berat Kosong</h5></div>
                                                    <div class="col-sm-1"><h5>:</h5></div>
                                                    <div class="col-sm-3" style="text-align:right;"><h5>999.999</h5></div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-4"><h5>Total Berat Bersih</h5></div>
                                                    <div class="col-sm-1"><h5>:</h5></div>
                                                    <div class="col-sm-3" style="text-align:right;"><h5>999.999.999</h5></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <div class="col-sm-2 col-sm-offset-3">
                                                    <button class="btn btn-success btn-sm browseBtn pull-left" type="submit"><i class="fa fa-eye"></i> View</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="row">
                            <div class="col-lg-12">                            
                                <div class="table-responsive ">
                                    <table id="listDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
                                        <thead>
                                            <tr>
                                                <th style="vertical-align:middle; text-align:center;">Nomor</th>
                                                <th style="vertical-align:middle; text-align:center;">Vendor ID</th>
                                                <th style="vertical-align:middle; text-align:center;">Nama Vendor</th>
                                                <th style="vertical-align:middle; text-align:center;">Tanggal</th>
                                                <th style="vertical-align:middle; text-align:center;">ID Kendaraan</th>
                                                <th style="vertical-align:middle; text-align:center;">Nomor Kendaraan</th>
                                                <th style="vertical-align:middle; text-align:center;">Berat Kotor</th>
                                                <th style="vertical-align:middle; text-align:center;">Berat Kosong</th>
                                                <th style="vertical-align:middle; text-align:center;">Berat Bersih</th>
                                                <th style="vertical-align:middle; text-align:center;">Status</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-sm-8"></div>
                                    <div class="col-sm-2">
                                        <button class="btn btn-info btn-sm btn-block printBtn pull-left" type="submit"><i class="fa fa-print"></i> Print</button>
                                    </div>
                                    <div class="col-sm-2">
                                        <button class="btn btn-danger btn-sm btn-block backBtn pull-left" type="submit"><i class="fa fa-arrow-circle-left"></i> Close</button>
                                    </div>                                                
                                </div>
                            </div>
                        </div>
                    </div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
   $(document).ready(function() {
		$('#form_filter').submit(function(e) {
			refreshDataTable(true);
			e.preventDefault();
		});

		var listDataTable = $('#listDataTable')
			.on('preXhr.dt', function(e, settings, data) {
				// $('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'ordering': true,
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "coalgetting_report/listPage",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.filter_date_start = $('#filter_date_start').val(),
						d.filter_date_end = $('#filter_date_end').val(),
						d.filter_vendor = $('#filter_vendor').val(),
						d.filter_number = $('#filter_nomor').val(),
						d.filter_status = $('#filter_status').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						// $('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [
					// {
					// 	"render": function(data, type, row) {
					// 		return getViewButton(row['coal_get_number']);
					// 	},
					// 	"targets": 0,
					// 	"orderable": true
					// },
                    {
						"render": function(data, type, row) {
							return row['vendor_id']?row['vendor_id']:'-';
						},
						"targets": 1,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							return row['vendor_name']?row['vendor_name']:'-';
						},
						"targets": 2,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							var res = format_date(row['coal_get_date']);
							return res;
						},
						"targets": 3,
						// "width": "7%",
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							return row['vehicle_id']?row['vehicle_id']:'-';
						},
						"targets": 4,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							return row['vehicle_number']?row['vehicle_number']:'-';
						},
						"targets": 5,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['gross_weight']);
						},
						"className": 'text-right',
						"targets": 6,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['tare_weight']);
						},
						"className": 'text-right',
						"targets": 7,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['net_weight']);
						},
						"className": 'text-right',
						"targets": 8,
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['status']?row['status']:'-';
						},
						"targets": 9,
						"orderable": true
					}
				],
				'columns': [{
						data: 'coal_get_number'
					},
					{
						data: 'vendor_id'
					},
					{
						data: 'vendor_name'
					},
					{
						data: 'coal_get_date'
					},
					{
						data: 'vehicle_id'
					},
					{
						data: 'vehicle_number'
					},
					{
						data: 'gross_weight'
					},
					{
						data: 'tare_weight'
					},
					{
						data: 'net_weight'
					},
					{
						data: 'status'
					},
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					// $('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
						extend: 'copy'
					},
					
				],
			});
			

		$('.exportExcelBtn').hide();
		new $.fn.dataTable.Buttons(listDataTable, {
			buttons: [{
				text: '<i class="fa fa-file-excel-o"></i> Export Excel',
				extend: 'excel',
				className: ' btn_modules_3 pull-left exportExcelBtn btn-xs btn-skin btn-primary',
				extension: '.xlsx'
			}]
		});
		// Add the Print button to the toolbox
		listDataTable.buttons(1, null).container().appendTo('.ibox-tools');
		$(".exportExcelBtn").removeClass("btn-default");
		$(".dt-buttons").addClass("pd-4");
		$(".dt-buttons").addClass("pull-left");
	});

	function refreshDataTable($reset_page = false) {
		$('#listDataTable').DataTable().ajax.reload(null, $reset_page);
	}
</script>