<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vehicle_mutation extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('vehicle_model');
		$this->bc->set_title('Vehicle Mutation');
		$this->bc->add('Master',base_url().'master');
		$this->bc->add('Vehicle Mutation',base_url().'master/vehicle_mutation');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'vehicle_mutation/main'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
		$data = array();
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vendor_id'] 			= $this->input->post('t_vendor_id');
		
		$this->db->trans_start();		
		// simpan 
		$save = $this->vehicle_model->save($data);
       
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->success('Save Success');
		}
	}

}