<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Bank_account_balance extends MY_Controller
{

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('bank_account_balance_model');
		$this->bc->set_title('Bank Account Balance');
		$this->bc->add('Dashboard', base_url() . 'dashboard');
		$this->bc->add('Finance & Accounting Dashboard', base_url() . 'finance_accounting_dashboard');
		$this->bc->add('Dashboard Bank Account Balance', base_url() . 'bank_account_balance');
	}

	public function index()
	{
		$data = array(
			'content' => 'bank_account_balance/main'
		);
		$this->load->view('tpl', $data);
	}

	public function load_chart()
	{
		$stacked = $this->input->post('stacked')?:false;
		$entity = $this->input->post('entity');
		$description = $this->input->post('description');
		$type = $this->input->post('type');
		$canvasHeight = $this->input->post('canvasHeight') ?: 200;
		$tableFont = $this->input->post('tableFont') ?: 15;
		$leftClass = $this->input->post('leftClass') ?: 'col-md-6';
		$rightClass = $this->input->post('rightClass') ?: 'col-md-6';

		$list_chart_data = array();
		if ($entity == 'ALL') {
			$list_data_grouped = array();
			$this->bank_account_balance_model->set_order(array('businessUnitCode' => 'ASC'));
			$get_list = $this->bank_account_balance_model->get_list();
			$list_data = $get_list->result_array();
			$saldo = 0;
			$tmp_business_code = '';
			foreach ($list_data as $row) {
				if ($row['businessUnitCode'] != $tmp_business_code) {
					$saldo = 0;
				}
				$saldo = $saldo + $row['saldo'];
				$list_data_grouped[$row['businessUnitCode']]['value'] = $saldo;
				$list_data_grouped[$row['businessUnitCode']]['caption'] = $row['accountName'];
				$list_data_grouped[$row['businessUnitCode']]['color'] = $row['colorCode'];
				$tmp_business_code = $row['businessUnitCode'];
			}
			foreach($list_data_grouped as $newRow)
			{
				$d['caption'] = $newRow['caption'];
				$d['value'] = $newRow['value'];
				$d['color'] = $newRow['color'];

				$list_chart_data[] = $d;
			}
		} else {
			$this->bank_account_balance_model->set_where(array('businessUnitCode' => $entity));
			$get_list = $this->bank_account_balance_model->get_list();
			$list_data = $get_list->result_array();
			foreach ($list_data as $row) {
				$d['caption'] = $row['bankName'];
				$d['value'] = $row['saldo'];
				$d['color'] = $row['colorCode'];

				$list_chart_data[] = $d;
			}
		}
		$data = array(
			'content' => 'bank_account_balance/chart',
			'list_chart_data' => $list_chart_data,
			'canvasHeight' => $canvasHeight,
			'tableFont' => $tableFont,
			'leftClass' => $leftClass,
			'rightClass' => $rightClass,
			'type' => $type,
			'stacked' => $stacked,
			'entity' => $entity,
			'description' => $description
		);
		$this->load->view($data['content'], $data);
	}

	public function show_404()
	{
		echo "404 ";
	}
}
