<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<!-- <//?=form_header('8')?> -->
				<div class="ibox-content">
					<div class="filter-content" style="">
						<form autocomplete="off" method="post" id="form_filter" class="form-horizontal">
							<div class="row">
								<div class="col-sm-12">
									<div class="col-sm-8">
										<br>
										<div class="form-group" id="daterange">
											<label class="col-sm-2">Tanggal</label>
											<div class="input-daterange input-group col-sm-4" id="datepicker">
												<input id="filter_date_start" type="text" class="input-sm form-control" name="t_filter_date_start" value="01<?= date('-m-Y') ?>" />
												<span class="input-group-addon">to</span>
												<input id="filter_date_end" type="text" class="input-sm form-control" name="t_filter_date_end" value="<?= date('d-m-Y') ?>" />
											</div>
										</div>
										<div class="form-group">
											<label class="col-sm-2">Vendor</label>
											<div class=" input-group col-sm-4">
												<input type="text" class="form-control" id="filter_vendor" name="t_filter_vendor" value="">
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-sm-6">
									<div class="form-group">
										<div class="col-sm-2 col-sm-offset-3">
											<button class="btn btn-success btn-sm browseBtn pull-left" type="submit"><i class="fa fa-search"></i> Refresh</button>
										</div>
									</div>
								</div>
							</div>
						</form>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="row">
						<div class="col-lg-8">
							<div class="table-responsive ">
								<table id="listDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
									<thead>
										<tr>
											<th style="vertical-align:middle; text-align:center;">Nomor</th>
											<th style="vertical-align:middle; text-align:center;">Vendor ID</th>
											<th style="vertical-align:middle; text-align:center;">Nama Vendor</th>
											<th style="vertical-align:middle; text-align:center;">Tanggal</th>
											<th style="vertical-align:middle; text-align:center;">ID Kendaraan</th>
											<th style="vertical-align:middle; text-align:center;">Berat Standard (ton)</th>
										</tr>
									</thead>
								</table>
							</div>
						</div>
						<div class="col-lg-4">
                            <div id=resultSummaryReport></div>
							<div class="row">
								<div class="col-sm-7"></div>
								<div class="col-sm-3">
									<button class="btn btn-info btn-sm printBtn btn-block pull-right" type="submit"><i class="fa fa-print"></i> Print</button>
								</div>
								<!-- <div class="col-sm-4">
									<button class="btn btn-danger btn-sm backBtn pull-right" type="submit"><i class="fa fa-arrow-circle-left"></i> Close</button>
								</div> -->
							</div>
                        </div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
		$('#form_filter').submit(function(e) {
			refreshDataTable(true);
			e.preventDefault();
		});		

		// loadSummaryReport();

		var listDataTable = $('#listDataTable')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'ordering': true,
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "report_overburden/listPage",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.filter_date_start = $('#filter_date_start').val(),
						d.filter_date_end = $('#filter_date_end').val(),
						d.vendor_filter = $('#filter_vendor').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						$('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [
					// {
					// 	"render": function(data, type, row) {
					// 		return getViewButton(row['over_burden_number']);
					// 	},
					// 	"targets": 0,
					// 	"orderable": true
					// },
					{
						"render": function(data, type, row) {
							return row['vendor_id']?row['vendor_id']:'-';
						},
						"targets": 1,
						// "width": "7%",
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['vendor_name']?row['vendor_name']:'-';
						},
						"targets": 2,
						// "width": "7%",
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							var res = format_date(row['over_burden_date']);
							return res;
						},
						"targets": 3,
						// "width": "7%",
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['vehicle_id']?row['vehicle_id']:'-';
						},
						"targets": 4,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['default_weight'],2,'.',',');
						},
						"className": 'text-right',
						"targets": 5,
						"orderable": true
					}
				],
				'columns': [{
						data: 'over_burden_number'
					},
					{
						data: 'vendor_id'
					},
					{
						data: 'vendor_name'
					},
					{
						data: 'over_burden_date'
					},
					{
						data: 'vehicle_id'
					},
					{
						data: 'default_weight'
					},
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					$('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
						extend: 'copy'
					},
					// {extend: 'csv'},
					// {extend: 'excel', title: 'ExampleFile'},
					// {extend: 'pdf', title: 'ExampleFile'},
					// {extend: 'print',
					// customize: function (win){
					// $(win.document.body).addClass('white-bg');
					// $(win.document.body).css('font-size', '10px');
					// $(win.document.body).find('table').addClass('compact').css('font-size', 'inherit');
					// }
					// }
				],
				footerCallback: function(row, data, start, end, display) {
					var _data = this.api().rows().data();
					var api = this.api(), data;

					var intVal = function ( i ) {
               			return typeof i === 'string' ?
                   		i.replace(/[\$,]/g, '')*1 :
                    	typeof i === 'number' ?
                        i : 0;
            		};
					
					_totaLob = api
						.column(5)
						.data()
						.reduce( function (a, b) {
							return intVal(a) + intVal(b);
						}, 0 );

					// document.getElementById("totalvol").innerHTML = number_format(_totaLob,2,'.',',');
					loadSummaryReport();
				},
			});
			

		$('.exportExcelBtn').hide();
		new $.fn.dataTable.Buttons(listDataTable, {
			buttons: [{
				text: '<i class="fa fa-file-excel-o"></i> Export Excel',
				extend: 'excel',
				className: ' btn_modules_3 pull-left exportExcelBtn btn-xs btn-skin btn-primary',
				extension: '.xlsx'
			}]
		});
		// Add the Print button to the toolbox
		listDataTable.buttons(1, null).container().appendTo('.ibox-tools');
		$(".exportExcelBtn").removeClass("btn-default");
		$(".dt-buttons").addClass("pd-4");
		$(".dt-buttons").addClass("pull-left");


		printBtn.click(function() {
			let post = {}
			var form_data = $("#form_filter").serialize();
			printDocPdf('overburden/overburden_report/print_doc_pdf?'+form_data,{button:$(this),post:post});
		});

	});

	function refreshDataTable($reset_page = false) {
		$('#listDataTable').DataTable().ajax.reload(null, $reset_page);
	}

	function loadSummaryReport(){
		var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "overburden/overburden_report/summaryReport",
            dataType: "html",
            type: "POST",
            data: formData,
            success: function(result) {
                $('#resultSummaryReport').html(result);               
            }
        })
    };
</script>