<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stockroom_outbound extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('mining_model');
		$this->load->model('hauling_model');
		$this->load->model('master/stockroom_model');
		$this->load->model('master/vendor_model');
		$this->load->model('master/vehicle_model');
		$this->bc->set_title('Stockroom Outbound');
		$this->bc->add('Stockroom',base_url().'hauling');
		$this->bc->add('Outbound',base_url().'hauling/stockroom_outbound');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'stockroom/main'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
        $mine_number = $this->input->post('t_mining_number')?:'empty';
		
		$data = array();
		$data['mine_date']	= date('Y-m-d');
		$data['mine_time']	= date('H:i:s');
		$data['mine_status']	= 1;
		$data['vendor_id'] 		= $this->input->post('t_vendor_id');
		$data['vendor_mis'] 		= $this->input->post('t_vendor_mis');
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['gross_weight'] 	= $this->input->post('t_gross_weight');
		$data['tare_weight'] 	= $this->input->post('t_tare_weight');
		$data['net_weight'] 	= $this->input->post('t_net_weight');

		$data['net_weight'] 	= validate_input(
			floatval(preg_replace('/[^\d.]/', '', $this->input->post('t_net_weight')))
			,array(
				'name'=>'Net Weight',
				'required'=>false,
				'type'=>'float'
			)
		);

		$data['stockroom_id'] 	= $this->input->post('t_stockroom_id');
		$data['id_rec'] 	= 1;

        if ($mine_number == 'empty') {
			$prefix =  date('y') . date('m')  . '.MIN.';
			$data['mine_number'] = $this->mining_model->gen_transaction_number($prefix);
		} else {
			$data['mine_number'] = $mine_number;
		}
		
		$this->db->trans_start();
		$save = $this->mining_model->save($data);
		if ($save){
			// save hauling
			$this->saveHaulingOut($data['vehicle_id'],$data['vehicle_number'],$data['gross_weight'],$data['vendor_id'],$data['stockroom_id']);
		}
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->result['vmin_number'] = $data['mine_number'];
			$this->result['vmin_date'] = $data['mine_date'];
			$this->result['vmin_time'] = $data['mine_time'];
			$this->success('Simpan Berhasil');
		}
	}

	public function getMining()
	{
		$post = $this->input->post();
		
        $where = array();
        $where['tbl.mine_number'] = $post['mine_num'];
		$this->mining_model->set_where($where);

		$mining_data = $this->mining_model->get_list_get($where);
		// echo $this->db->last_query();die;

        if (!$mining_data['mine_number']){
            $this->error('Nomor Mining Tidak Ditemukan');
        }
        $tgl = date('Y-m-d');
        $jam = date('H:i:s');
        $this->result['mining_data'] = $mining_data;
        $this->result['tgl'] = $tgl;
        $this->result['jam'] = $jam;
        $this->success('ok');		
	}

	function print_doc_pdf()
	{
		$trx_num = $this->input->post('id');
				
		$where = array();
        $where['tbl.mine_number'] = $trx_num;
		// $this->mining_model->set_where($where);
		$list_data = $this->mining_model->get_list_get($where);

		$data = array(
			'content' 	=> 'stockroom/print', 
			'list_data'	=> $list_data
		);
		
		$this->load->view($data['content'],$data); 
	}

	function saveHaulingOut($vehicle_id,$vehicle_number,$gross_weight,$vendor_id,$stockroom_id)
	{
		$where = array();
        $where['tbl.vehicle_id'] = $vehicle_id;
        $where['tbl.hauling_number'] = 'empty';
		$this->hauling_model->set_where($where);
		$hauling_out = $this->hauling_model->get_list_get($where);	
		$recnum = $hauling_out['id_rec']; 	

		$vendor_data = $this->vendor_model->get(array("vendor_mis" => $vendor_id));
		$vendor_mis = $vendor_data['vendor_mis'];

		$stockroom_data = $this->stockroom_model->get(array("stockroom_id" => $stockroom_id));
		$origin_type = $stockroom_data['origin_type'];

		if($origin_type == 'STOCKROOM'){
			$ongkos = $vendor_data['stockr_cost'];
		}  
		if($origin_type == 'STOCKROOM2'){
			$ongkos = $vendor_data['stockr_cost2'];
		} 
		if($origin_type == 'PIT'){
			$ongkos = $vendor_data['pit_cost'];
		} 

		$vehicle_data = $this->vehicle_model->get(array("vehicle_id" => $vehicle_id));
		$vendor_subcon = $vehicle_data['vendor_subcon'];
		
		$data = array();
		$data['vehicle_id'] 	= $vehicle_id;
		$data['vehicle_number'] = $vehicle_number;
		$data['gross_weight'] 	= $gross_weight;
		// $data['vendor_mis'] 	= $vendor_mis;
		$data['origin_type'] 	= $origin_type;
		// $data['vendor_subcon'] 	= $vendor_subcon;
		$data['ongkos'] 	= $ongkos;
		$data['hauling_status']	= 1;
		$data['hauling_out_date']	= date('Y-m-d');
		$data['hauling_out_time']	= date('H:i:s');
		$data['hauling_number']	= 'empty';

		if ($recnum) {
			$data['id_rec']	  = $recnum;
		} else {
			$data['id_rec'] 	  = $this->hauling_model->gen_recnum($data['vehicle_id']);
		}
		
		$this->db->trans_start();
		$save = $this->hauling_model->save($data);
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
		}
	}

}