<?php
class Mypdf extends fpdf
{
	// Page header
	var $params_header = array();

    /**
     * generate page header
     * @param set with function set_params_header() 
     * @return cell
     */
	function Header()
	{
		// Logo
		// $image_logo = $this->Image('assets/img/elcorps_logo.png',10,6,30);
		// Arial bold 15
		$this->SetFont('Arial', 'B', 15);

		$text_left = isset($this->params_header['text_left']) ? $this->params_header['text_left'] : '';
		$text_center = isset($this->params_header['text_center']) ? $this->params_header['text_center'] : '';
		$text_right = isset($this->params_header['text_right']) ? $this->params_header['text_right'] : '';

		if ($text_left != '') {
			$this->Cell(0, 2, $text_left, 0, 0, 'L');
			$this->SetX($this->lMargin);
		}
		if ($text_center != '') {
			$this->Cell(0, 2, $text_center, 0, 0, 'C');
			$this->SetX($this->lMargin);
		}
		if ($text_right != '') {
			$this->Cell(0, 2, $text_right, 0, 0, 'R');
		}
		// $this->Cell(80);
		// Title
		// $this->Cell(30,10,$this->title,1,0,'C');
		// Line break
		$this->Ln(5);
	}

    /**
     * generate page footer
     * @return cell
     */
	function Footer()
	{
		// Position at 1 cm from bottom
		$this->SetY(-10);
		// Arial italic 8
		$this->SetFont('Arial', 'I', 8);
		// Page number
		$this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
	}

    /**
     * generate page header
     * @param array $params = ['text_left','text_center','text_right']
     * @return cell
     */
	function set_params_header($params)
	{
		$this->params_header = $params;
	}
}
