<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mining_model extends Base_Model
{

	function __construct()
	{

		parent::__construct();
		$this->set_table('mining');
		$this->set_pk('mine_number');
		$this->set_log(false);
	}

	function count()
	{
		$data = array();
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');
        $this->db->join('trans_status sts','tbl.mine_status=sts.trans_status','left');
        $this->db->join('vehicle vhc','tbl.vehicle_id=vhc.vehicle_id','left');

		$this->db->where($this->where);
		$this->db->or_like($this->like);

		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
	
		return $query->num_rows();
	}

	function get_list()
	{
		$this->db->select('tbl.*');
		$this->db->select('vnd.vendor_name');
		$this->db->select('sts.status');
		$this->db->select('vhc.vendor_id as vehicle_vendorid');
		$this->db->select('vhc.tare_weight as vehicle_tare_weight');
		$this->db->join('vendor vnd','tbl.vendor_id=vnd.vendor_id','left');
		$this->db->join('trans_status sts','tbl.mine_status=sts.trans_status','left');
		$this->db->join('vehicle vhc','tbl.vehicle_id=vhc.vehicle_id','left');
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}


	function gen_transaction_number($prefix='')
	{
		$transnumber_length	= 16;
		
		$this->db->select('RIGHT(tbl.mine_number,7) mine_number',false);
		$this->db->order_by('tbl.mine_number','DESC');
		$this->db->group_by('tbl.mine_number');
		
		$prefix_length		= strlen($prefix);
		$autonumber_length	= $transnumber_length - $prefix_length;
		
		$this->db->where("LEFT(tbl.mine_number,9) = '$prefix' AND CHAR_LENGTH(tbl.mine_number) = $transnumber_length");
		
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl','1','0');
		// echo $this->db->last_query();
		// exit;
		
		$no_last =  $query->row_array();
		$no_next = 1;
		if ($no_last)
		{
			$no_next = $no_last['mine_number']+1;
		}

		$no = $prefix.sprintf('%0'.$autonumber_length.'s', $no_next);
	
		$query->free_result();
		
		return $no;
	} 

	public function gen_recnum($prefix)
	{
		$this->db->select('IFNULL( MAX( id_rec ), 0 ) + 1 last_recnum',false);
		$this->db->where(array('vehicle_id'=>$prefix));
		$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		$query_row = $query->row_array();
		return $query_row['last_recnum'];
	}

	function get_list_summary()
	{
		$this->db->select('tbl.vendor_id');
		$this->db->select('sum(tbl.net_weight) as net_weight',false);
		$this->db->group_by('tbl.vendor_id');
		
		if($this->where)
		$this->db->where($this->where);
		if($this->like)
		$this->db->or_like($this->like);
		
		foreach ($this->order_by as $key => $value)
		{
			$this->db->order_by($key, $value);
		}

		if (!$this->limit AND !$this->offset)
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl');
		else
			$query = $this->db->get($this->schema.'.'.$this->table.' tbl',$this->limit,$this->offset);
		
        if($query->num_rows()>0)
		{
			return $query;
        
		}else
		{
			$query->free_result();
            return $query;
        }
	}


	function update_header($transnum,$date1,$date2,$vendor)
	{
		$qry = '
		UPDATE mining
		SET mine_recapnum = '.quotedStr($transnum).'
		    , mine_status = 3 
		WHERE
		 mine_status = 1 
		 AND mine_date BETWEEN '.quotedStr($date1).' 
		 AND '.quotedStr($date2).'
		 AND vendor_id ='.quotedStr($vendor) ;
		$query = $this->db->query($qry);
	}

}
