<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vehicle extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('vehicle_model');
		$this->load->model('vendor_model');
		$this->bc->set_title('Vehicle');
		$this->bc->add('Master',base_url().'master');
		$this->bc->add('vehicle',base_url().'master/vehicle');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'vehicle/main'
		);
		$this->load->view('tpl',$data);
	}

	function get_vehicle(){
        $post = $this->input->post();
		
        $where = array();
        $where['tbl.vehicle_id'] = $post['vehicle_id'];
        $vehicle = $this->vehicle_model->get($where);
        if (!$vehicle['vehicle_id']){
            $this->error('ID Kendaraan Tidak Ditemukan');
        }
		$vendor = $vehicle['vendor_id'];
		$vendor_data = $this->vendor_model->get(array('vendor_id' => $vendor));
        $tgl = date('Y-m-d');
        $jam = date('H:i:s');
        $this->result['vehicle'] = $vehicle;
        $this->result['vendor_id'] = $vendor;
		$this->result['vendor_name'] = $vendor_data['vendor_name'];
        $this->result['tgl'] = $tgl;
        $this->result['jam'] = $jam;
        $this->success('ok');
    }

	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		
		$where = array();
		$where["(
			tbl.vehicle_id LIKE '%$searchValue%'
			OR tbl.vehicle_number LIKE '%$searchValue%'
			OR tbl.vendor_id LIKE '%$searchValue%'
			OR vnd.vendor_name LIKE '%$searchValue%'
		)"] = NULL;
		
		$this->vehicle_model->set_where($where);
		
		$list_count = $this->vehicle_model->count_vendormis();
		$this->vehicle_model->set_limit($rowperpage);
		$this->vehicle_model->set_offset($start);
		$this->vehicle_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->vehicle_model->get_list_vendormis();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($vehicle_id='')
	{
		$decoded_vehicle_id = decode($vehicle_id);
		$vehicle_data = $this->vehicle_model->get_list_get(array('vehicle_id'=>$decoded_vehicle_id));

		if($vehicle_data['vehicle_id']){
			$vendor_name = $vehicle_data['vendor_name'];
		} else {
			$vendor_name = '';
		}
		
		$data = array(
			'content' => 'vehicle/input'
			,'vehicle_data' => $vehicle_data
			,'vendorname' => $vendor_name
		);

		$this->load->view('tpl',$data);
	}

	function save()
	{
		$data = array();
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['vendor_id'] 			= $this->input->post('t_vendor_id');
		$data['vendor_mis'] 		= $this->input->post('t_vendor_id');
		$data['vendor_subcon'] 		= strtoupper($this->input->post('t_vendor_subcon'));
		$data['default_weight'] 	= $this->input->post('t_default_weight');
		$data['tare_weight'] 		= $this->input->post('t_tare_weight');
		$data['fuel_convertion'] 	= $this->input->post('t_fuel_conv');
		
		$this->db->trans_start();		
		// simpan 
		$save = $this->vehicle_model->save($data);
       
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->success('Save Success');
		}
	}

}