<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox">
				
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a type="button" class="btn btn_modules_1 loadingButton pull-right btn-xs btn-skin btn-success" href="<?=base_url(uri_string())?>/input/'+000"><i class="fa fa-plus-circle"></i> Create New</a> 
                </div>
            </div>

				<div class="ibox-content">
					<div class="clients-list">

						<div class="table-responsive ">
							<table id="clientDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
								<thead>
									<tr>
                                        <th>Vendor Card</th>
										<th>Vendor Master Card</th>
										<th>Vendor Name</th>
										<th>Pit Cost</th>
										<th>Stock Room Cost</th>
										<th>Stock Room 2 Cost</th>
										<th>Diff Cost</th>
									</tr>
								</thead>
							</table>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$('#clientDataTable').DataTable({
			'processing': true,
			'serverSide': true,
			'serverMethod': 'post',
			'ajax': {
				'url': site_url + "master/vendor/listPage",
				'data': function(d) {}
			},
			"columnDefs": [{
					"render": function(data, type, row) {
						return getViewButton(row['vendor_id']);
					},
					"targets": 0,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						var res = number_format(row['pit_cost'], 0, ',', '.');
						return res;
					},
					className: 'text-right',
					"targets": 3,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						var res = number_format(row['stockr_cost'], 0, ',', '.');
						return res;
					},
					className: 'text-right',
					"targets": 4,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						var res = number_format(row['stockr_cost2'], 0, ',', '.');
						return res;
					},
					className: 'text-right',
					"targets": 5,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						var res = number_format(row['biaya_selisih'], 0, ',', '.');
						return res;
					},
					className: 'text-right',
					"targets": 6,
					"orderable": true
				},
			],
			'columns': [{
					data: 'vendor_id'
				},
				{
					data: 'vendor_mis'
				},
				{
					data: 'vendor_name'
				},
				{
					data: 'pit_cost'
				},
				{
					data: 'stockr_cost'
				},
				{
					data: 'stockr_cost2'
				},
				{
					data: 'biaya_selisih'
				}
			],
			initComplete: function() {},
		});

	});

	function getViewButton(vendor_id) {
		return '<a data-style="zoom-in" type="button" class="btn btn_modules_10 btn-xs loadingButton" href="<?= base_url(uri_string()) ?>/input/' + encode(vendor_id) + '">' + vendor_id + '</a>'
	}

	function refreshDataTable() {
		$('#clientDataTable').DataTable().ajax.reload(null, false);
	}
</script>