<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox float-e-margins">
				<?= form_header('6') ?>
				<div class="ibox-content">
					<div class="filter-content" style="display:none">
						<form autocomplete="off" method="post" id="form_filter" class="form-horizontal">
							<div class="row">
								<div class="col-sm-12">
									<div class="col-sm-6">
										<div class="form-group">
											<label class="col-sm-4 control-label">Business Unit</label>
											<div class=" input-group col-sm-8">
												<input type="text" class="form-control" value="<?= $this->session->userdata('businessUnitCode') ?> - <?= $this->session->userdata('businessUnitname') ?>" readonly>
											</div>
										</div>
										<div class="form-group" id="daterange">
											<label class="col-sm-4 control-label">Periode</label>
											<div class="input-daterange input-group col-sm-6" id="datepicker">
												<input id="filter_date_start" type="text" class="input-sm form-control input_cached" name="t_filter_date_start" value="01<?= date('-m-Y') ?>" />
												<span class="input-group-addon">to</span>
												<input id="filter_date_end" type="text" class="input-sm form-control input_cached" name="t_filter_date_end" value="<?= date('d-m-Y') ?>" />
											</div>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="col-sm-4 control-label">Departement</label>
											<div class="input-group col-sm-8">
												<select id="status_dept" name="t_status_dept[]" data-placeholder="All Dept" multiple class="chosen-select input_cached" tabindex="0">
												</select>
											</div>
										</div>
										<div class="form-group">
											<label class="col-sm-4 control-label">Status</label>
											<div class="input-group col-sm-8">
												<select id="status_filter" name="t_status_filter[]" data-placeholder="Pilih..." multiple class="chosen-select input_cached" tabindex="0">
												</select>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="row">
								<div class="form-group">
									<div class="col-sm-4 col-sm-offset-2">
										<button class="btn btn-primary browseBtn" type="submit"><i class="fa fa-search"></i> Browse</button>
									</div>
								</div>
							</div>
						</form>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="table-responsive ">
						<table id="listDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
							<thead>
								<tr>
									<th>Account Code</th>
									<th>Account Name</th>
									<th>Parent Account Code</th>
									<th>Parent Account Name</th>
									<th>Level</th>
									<th>Cash</th>
									<th>Balance Sheet</th>
									<th>Income Statement</th>
									<th>Operational</th>
									<th>Invesment</th>
									<th>Funding</th>
									<th>Note</th>
								</tr>
							</thead>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function() {
		loadInputCache();
		$('#form_filter').submit(function(e) {
			refreshDataTable();
			e.preventDefault();
		});

		var listDataTable = $('#listDataTable')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "master/coa/listPage",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.filter_date_start = $('#filter_date_start').val(),
							d.filter_date_end = $('#filter_date_end').val(),
							d.status_filter = $('#status_filter').val(),
							d.status_dept = $('#status_dept').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						$('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [{
						"render": function(data, type, row) {
							return getViewButton(row['accountCode']);
						},
						"targets": 0,
						"orderable": true
					}
				],
				'columns': [{
						data: 'accountCode'
					},
					{
						data: 'accountName'
					},
					{
						data: 'accountParentCode'
					},
					{
						data: 'accountParentName'
					},
					{
						data: 'accountLevel'
					},
					{
						data: 'cash'
					},
					{
						data: 'balanceSheet'
					},
					{
						data: 'incomeStatement'
					},
					{
						data: 'operational'
					},
					{
						data: 'investment'
					},
					{
						data: 'funding'
					},
					{
						data: 'note'
					},
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					$('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
					storeInputCache();
				},
				buttons: [{
						extend: 'copy'
					},
				],
			});
			
	});

	function getViewButton(trans_id) {
		return '<a data-style="zoom-in" type="button" class="btn btn_modules_10 btn-xs loadingButton" href="<?= base_url(uri_string()) ?>/input/' + encode(trans_id) + '">' + trans_id + '</a>'
	}

	function refreshDataTable() {
		$('#listDataTable').DataTable().ajax.reload(null, false);
	}
</script>