<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Overburden_report extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('overburden_model');
		$this->bc->set_title('Overburden Report');
		$this->bc->add('Overburden',base_url().'overburden');
		$this->bc->add('Overburden Report',base_url().'overburden/report_overburden');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'overburden_report/main'
		);
		$this->load->view('tpl',$data);
	}
	
	public function listPage()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('vendor_filter');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['over_burden_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['over_burden_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor) {
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$where["(
			tbl.over_burden_number LIKE '%$searchValue%'
			OR vnd.vendor_name LIKE '%$searchValue%'
			OR tbl.vehicle_id LIKE '%$searchValue%'
		)"] = NULL;

		$this->overburden_model->set_where($where);
		
		$list_count = $this->overburden_model->count();
		$this->overburden_model->set_limit($rowperpage);
		$this->overburden_model->set_offset($start);
		$this->overburden_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->overburden_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function summaryReport()
	{
		$filter_vendor 	= $this->input->post('t_filter_vendor');
		$date_start = validate_input($this->input->post('t_filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['over_burden_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['over_burden_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$tgl1 = new DateTime($filter_date_start);
		$tgl2 = new DateTime($filter_date_end);
		$days = $tgl2->diff($tgl1)->days + 1;
		$dayshour = ($days * 24) ;

		if ($filter_vendor) {
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$this->overburden_model->set_where($where);
		$vhclcount = $this->overburden_model->count();
		$totalob = $this->overburden_model->getTotalOverburden();
		$totalhr = ( $totalob / $dayshour );
		$vehiclehr = ($vhclcount / $dayshour);
		// echo $this->db->last_query(); die;
		$data = array(
			'content' => 'overburden_report/summary',
			'totalob' => $totalob,
			'totalhr' => $totalhr,
			'vehclob' => $vhclcount,
			'vehclhr' => $vehiclehr
		);
		$this->load->view($data['content'], $data);
	}

	public function print_doc_pdf()
	{
		$f_date_start = $this->input->get('t_filter_date_start');
		$f_date_end = $this->input->get('t_filter_date_end');
		$date_start = validate_input($f_date_start,
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($f_date_end,
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['over_burden_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['over_burden_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		$tgl1 = new DateTime($filter_date_start);
		$tgl2 = new DateTime($filter_date_end);
		$days = $tgl2->diff($tgl1)->days + 1;
		$dayshour = ($days * 24) ;

		$filter_vendor 	= $this->input->get('t_filter_vendor');

		if ($filter_vendor) {
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$this->overburden_model->set_where($where);

		$vhclcount = $this->overburden_model->count();
		$totalob = $this->overburden_model->getTotalOverburden();
		$totalhr = ( $totalob / $dayshour );
		$vehiclehr = ($vhclcount / $dayshour);

		$list_data  = $this->overburden_model->get_list();

		$data = array(
			'content' => 'overburden_report/printpdf', 
			'listdata'=> $list_data,
			'totalob' => $totalob,
			'totalhr' => $totalhr,
			'vehclob' => $vhclcount,
			'vehclhr' => $vehiclehr,
			// 'debug'	  => 1
		);

		$option = array(
			'paper_size' => 'A4' 
		);

		$this->load_pdf($data['content'], $data, $option);
	}

}