<?php
$div_id = getGUID();
?>
<div class="row">
	<div class="<?=$leftClass?>">
		<canvas id="<?=$div_id?>" height="<?=$canvasHeight?>"></canvas>
	</div>
	<div class="<?=$rightClass?>">
		<div class="table-responsive">
			<table class="table mb-0" style="font-size : <?=$tableFont?>px">
				<thead class="bg-yellow bg-lighten-4">
					<tr>
						<th class=""></th>
						<th class="">Bank name</th>
						<th style="text-align: right;">Balance</th>
					</tr>
				</thead>
				<tbody>
					<?php
$total = 0;
foreach ($list_chart_data as $key => $row) {
    $total = $total + $row['value'];
    ?>
						<tr>
							<td><span class="label" style="background-color: <?=$row['color']?>;">&nbsp;</span></td>
							<td class=""><?=$row['caption']?></td>
							<td style="text-align: right;"><?=number_format($row['value'])?></td>
						</tr>
					<?php }?>
				</tbody>
				<tfoot class="bg-yellow bg-lighten-4">
					<tr>
						<th colspan="2">Total</th>
						<th style="text-align: right;"><?=number_format($total)?></th>
					</tr>
				</tfoot>
			</table>
		</div>
	</div>
</div>

<script>
var stacked = <?=$stacked?1:0?>;
<?php
/* CHART 0*/
$chart_labels = '';
$chart_data = '';
$chart_color = '';
$stacked_chart_labels = '';
$stacked_chart_datasets = array();
foreach ($list_chart_data as $key => $row) {
    if ($key != 0) {
        $chart_labels .= ',';
        $chart_data .= ',';
        $chart_color .= ',';
        $stacked_chart_labels .= ',';
    }
    $stacked_chart_labels .= $row['caption'];
    $chart_labels .= '"' . $row['caption'] . '"';
    $chart_data .= $row['value'];
    $chart_color .= '"' . $row['color'] . '"';
    $stacked = array(
        'label' => $row['caption'],
        'data' => array(0 => $row['value']),
        'backgroundColor' => $row['color'],
    );
    $stacked_chart_datasets[] = $stacked;
}
?>
if(stacked)
{
	var chart_data = {
		labels: ["<?=$description?>"],
		datasets: <?=json_encode($stacked_chart_datasets)?>
	};
	console.log(chart_data);
}else{
	var chart_data = {
		labels: [<?=$chart_labels?>],
		datasets: [{
			data: [<?=$chart_data?>],
			backgroundColor: [<?=$chart_color?>]
		}]
	};
}

	var chart_options = {
		legend: {
			display: false
		},
		responsive: true,
		tooltips: {
			callbacks: {
				label: function(tooltipItem, data) {
					var dataset = data.datasets[tooltipItem.datasetIndex];
					var total = dataset.data.reduce(function(previousValue, currentValue, currentIndex, array) {
						return previousValue + currentValue;
					});
					var currentValue = dataset.data[tooltipItem.index];
					var percentage = Math.floor(((currentValue / total) * 100) + 0.5);
					var label = data.labels[tooltipItem.index];
					var value = data.datasets[0].data[tooltipItem.index];
					value = value.toString();
					value = value.split(/(?=(?:...)*$)/);
					value = value.join(',');
					return label + ' : ' + value + ' (' + percentage + '%)';
				}
			} // end callbacks:
		}, //end tooltips
		pieceLabel: {
			render: function(args) {
				return args.label + ' (' + args.percentage + '%)';
			},
			fontColor: '#000',
			position: 'outside',
			segment: true,
			// arc: true
		},
	};

	if ('<?=$type?>' == 'bar') {
		chart_options['scales'] = {
			yAxes: [{
				ticks: {
					min: 0,
	        userCallback: function(value, index, values) {
	            value = number_format(value);
	            return value;
	        }
				}
			}]
		};
	}

	if ('<?=$type?>' == 'horizontalBar') {
		chart_options['scales'] = {
			xAxes: [{
				stacked: stacked,
				ticks: {
					min: 0,
	        userCallback: function(value, index, values) {
	            value = number_format(value);
	            return value;
	        }
				}
			}],
			yAxes: [{
				stacked: stacked,
			}]
		};
		chart_options['tooltips'] = {
			mode:'label'
		}
	}

	var ctx0 = document.getElementById("<?=$div_id?>").getContext("2d");
	new Chart(ctx0, {
		type: '<?=$type?>',
		data: chart_data,
		options: chart_options
	});
</script>