<div class="row">
	<div class="col-lg-12">
			<form method="get" class="form-horizontal">
				<div class="form-group"><label class="col-sm-2 control-label">Item Group</label>
					<div class="col-sm-10">
						<select id="id_item_group" name="t_id_item_group" data-placeholder="Pilih..." class="chosen-select" tabindex="0">
						</select>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="form-group"><label class="col-sm-2 control-label">Category</label>
					<div class="col-sm-10">
						<select id="id_category" name="t_id_category" data-placeholder="Pilih..." class="chosen-select" tabindex="0">
						</select>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="form-group"><label class="col-sm-2 control-label">M-Class</label>
					<div class="col-sm-10">
						<select id="id_mclass" name="t_id_mclass" data-placeholder="Pilih..." class="chosen-select" tabindex="0">
						</select>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="form-group">
					<div class="col-sm-4 col-sm-offset-2">
						<button class="btn btn-primary" type="button" onclick="updateStyle()"><i class="fa fa-plus"></i> Add new Style</button>
					</div>
				</div>
			</form>
	</div>
	<div class="col-sm-12">
		<div class="table-responsive " style="width:100%">
			<table id="listDataTableCrudStyle" class="table table-striped table-bordered table-hover" style="width:100%;">
				<thead>
					<tr>
						<th>No</th>
						<th>ID Style</th>
						<th>Description</th>
						<th>*</th>
					</tr>
				</thead>
			</table>
		</div>
	</div>
</div>
<script>
var listDataTableCrudStyle;
	$(document).ready(function() {
		$('.chosen-select').chosen({width: "100%",search_contains: true});
		combo_item_group('<?=$id_item_group?>','<?=$id_category?>','<?=$id_mclass?>');
		$('#id_item_group').change(function() {
			combo_category($(this).val());
		});
		$('#id_category').change(function() {
			combo_mclass($('#id_item_group').val(),$(this).val());
		});
		$('#id_mclass').change(function() {
			refreshDataCrudStyle(true);
		});
		list_data_table();
	})

	function list_data_table()
	{
		listDataTableCrudStyle = $('#listDataTableCrudStyle')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "main/modal/crudStyleListPage",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.id_item_group = $('#id_item_group').val()?$('#id_item_group').val():<?=$id_item_group?:0?>,
							d.id_category = $('#id_category').val()?$('#id_category').val():<?=$id_category?:0?>,
							d.id_mclass = $('#id_mclass').val()?$('#id_mclass').val():<?=$id_mclass?:0?>
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						$('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [{
						render: function(data, type, row, meta) {
							return meta.row + meta.settings._iDisplayStart + 1;
						},
						"targets": 0,
						"orderable": false
					},
					{
						render: function(data, type, row) {
							return `<button class="btn btn-primary btn-xs" onClick="updateStyle('${row['IdStyle']}','${row['Description']}')"><i class="fa fa-pencil"></i></button>`;
						},
						"targets": 3,
						"orderable": false
					},
				],
				'columns': [{
						defaultContent: ''
					},
					{
						data: 'IdStyle'
					},
					{
						data: 'Description'
					},
					{
						defaultContent: ''
					}
				],
				order: [
					[1, 'asc']
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					$('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
					extend: 'copy',
					exportOptions: {
						orthogonal: 'export'
					}
				}, ],
			});
	}
	async function updateStyle(id_style = 0, text = '') {
		let id_item_group = $('#id_item_group').val();
		let id_category = $('#id_category').val();
		let id_mclass = $('#id_mclass').val();
		title = 'Add Style';
		if (id_style)
			title = 'Update Style ' + id_style
		var {
			value: formValues
		} = await Swal.fire({
			title: title,
			html: '<form id="form-input-style" autocomplete="off">' +
				'<input hidden id="swal-input1" value="' + id_style + '" name="id_style" class="swal2-input">' +
				'<input id="swal-input2" value="' + text + '" name="style_description" class="swal2-input" placeholder="Description">' +
				'<input hidden id="swal-input3" value="' + id_item_group + '" name="id_item_group" class="swal2-input">' +
				'<input hidden id="swal-input4" value="' + id_category + '" name="id_category" class="swal2-input">' +
				'<input hidden id="swal-input5" value="' + id_mclass + '" name="id_mclass" class="swal2-input">' +
				'</form>',
			focusConfirm: false,
			preConfirm: () => {
				if (!$('#swal-input2').val()) {
					Swal.showValidationMessage('Data belum di isi!');
					$('#swal-input2').focus();
				}
				return $('#form-input-style').serialize()
			}
		})

		if (formValues) {
			$.ajax({
				type: 'POST',
				url: site_url + "main/modal/saveCrudStyle/",
				dataType: 'json',
				data: formValues,
				success: function(response) {
					swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
						refreshDataCrudStyle();
					});
				},
				error: function(jqXhr, textStatus, errorThrown) {
					var error_message = 'internal error';
					if (jqXhr.responseJSON !== undefined) {
						error_message = jqXhr['responseJSON']['message'];
					}
					swal.fire('error', error_message, "error");
				}
			});
		}
	}

	function combo_item_group(def_item_group, def_id_category = null, def_id_mclass = null)
	{
		$.ajax({
			type: 'POST',
			url: site_url + "mms/product/getItemGroup/",
			dataType: 'html',
			success: function(result) {
				$('#id_item_group').empty();
				$('#id_item_group').append(result);
				$('#id_item_group').val(def_item_group).trigger("chosen:updated");
				combo_category($('#id_item_group').val(), def_id_category, def_id_mclass);
			}
		});
	}

	function combo_category(item_group = null, def_id_category = null, def_id_mclass = null) {
		$.ajax({
			type: 'POST',
			url: site_url + "mms/product/getComboCategory/",
			dataType: 'html',
			data: {
				item_group: item_group ? item_group : 0
			},
			success: function(result) {
				$('#id_category').empty();
				$('#id_category').append(result);
				$('#id_category').trigger("chosen:updated");
				if(def_id_category)
				$('#id_category').val(def_id_category).trigger("chosen:updated");
				combo_mclass($('#id_item_group').val(),$('#id_category').val(), def_id_mclass);
			}
		});
	}

	function combo_mclass(item_group = null, id_category = null, def_id_mclass = null) {
		$.ajax({
			type: 'POST',
			url: site_url + "mms/product/getComboMClass/",
			dataType: 'html',
			data: {
				item_group: item_group ? item_group : 0,
				id_category: id_category ? id_category : 0
			},
			success: function(result) {
				$('#id_mclass').empty();
				$('#id_mclass').append(result);
				$('#id_mclass').trigger("chosen:updated");
				if(def_id_mclass)
				$('#id_mclass').val(def_id_mclass).trigger("chosen:updated");
				refreshDataCrudStyle(true);
			}
		});
	}

	function refreshDataCrudStyle(reload_paging = false) {
		$('#listDataTableCrudStyle').DataTable().ajax.reload(null, reload_paging);
	}
</script>