<div class="table-responsive ">
    <table id="listDataTableReport" class="table table-striped table-bordered table-hover" style="width:100%;">
        <thead>
            <tr>
                <th style="vertical-align:middle; text-align:center;">Nomor Rekap</th>
                <th style="vertical-align:middle; text-align:center;">Tanggal Rekap</th>
				<th style="vertical-align:middle; text-align:center;">Vendor Master Card</th>
                <th style="vertical-align:middle; text-align:center;">Berat Kotor</th>
                <th style="vertical-align:middle; text-align:center;">Berat Kosong</th>
                <th style="vertical-align:middle; text-align:center;">Berat Bersih</th>
                <th style="vertical-align:middle; text-align:center;">Status</th>
                <th style="vertical-align:middle; text-align:center;">Print</th>
                <th style="vertical-align:middle; text-align:center;">Aksi</th>
            </tr>
        </thead>
    </table>
</div>

<script>
	$(document).ready(function() {
		$('#form_filter_report').submit(function(e) {
			refreshDataTableReport(true);
			e.preventDefault();
		});

		var listDataTableReport = $('#listDataTableReport')
			.on('preXhr.dt', function(e, settings, data) {
				// $('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'ordering': true,
				'processing': true,
				'serverSide': true,
				'responsive': true,
				'serverMethod': 'post',
				'ajax': {
					'async': true,
					'url': site_url + "hauling_recap/listPageReport",
					'beforeSend': function(xhr) {},
					'data': function(d) {
						d.filter_date_start = $('#filter_date_start_report').val(),
						d.filter_date_end = $('#filter_date_end_report').val(),
						d.filter_vendor = $('#filter_vendor_report').val()
					},
					'error': function(jqXhr, textStatus, errorThrown) {
						var error_message = 'internal error';
						if (jqXhr.responseJSON !== undefined) {
							error_message = jqXhr['responseJSON']['message'];
						}
						swal.fire('error', error_message, "error");
						// $('.browseBtn').ladda('stop');
					}
				},
				'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
				"columnDefs": [
					// {
					// 	"render": function(data, type, row) {
					// 		return getViewButton(row['hauling_recapnum']);
					// 	},
					// 	"targets": 0,
					// 	"orderable": true
					// },
                    {
						"render": function(data, type, row) {
							var res = format_date(row['hauling_recapdate']);
							return res;
						},
						"targets": 1,
						// "width": "7%",
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['vendor_mis']?(row['vendor_mis']+' - '+row['vendor_name']):'-';
						},
						"targets": 2,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['gross_weight'],2);
						},
						"className": 'text-right',
						"targets": 3,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['tare_weight'],2);
						},
						"className": 'text-right',
						"targets": 4,
						"orderable": true
					},
					{
						"render" : function(data ,type, row){
							return number_format(row['net_weight'],2);
						},
						"className": 'text-right',
						"targets": 5,
						"orderable": true
					},
					{
						"render": function(data, type, row) {
							return row['status']?row['status']:'-';
						},
						"targets":6,
						"orderable": true
					},
                    {
						"render": function(data, type, row) {
							var res =
								'<a class="btn btn-info btn-xs btn-block" onClick="printReport(`'+row['hauling_recapnum']+'`)">\
								<i class="fa fa-print"></i>\
								&nbsp;Print</a>';
							return res;
						},
						"targets": 7,
						"orderable": false
					},
                    {
						"render": function(data, type, row) {
							var res =
								'<a class="btn btn-danger btn-xs btn-block" onClick="sendEmail(`'+row['hauling_recapnum']+'`)">\
								<i class="fa fa-send"></i>\
								&nbsp;Email</a>';
							return res;
						},
						"targets": 8,
						"orderable": false
					},
				],
				'columns': [{
						data: 'hauling_recapnum'
					},
					{
						data: 'hauling_recapdate'
					},
					{
						data: 'vendor_mis'
					},
					{
						data: 'gross_weight'
					},
					{
						data: 'tare_weight'
					},
					{
						data: 'net_weight'
					},
					{
						data: 'status'
					},
					{
						data: ''
					},
					{
						data: ''
					},
				],
				initComplete: function() {},
				drawCallback: function(settings) {
					// $('.browseBtn').ladda('stop');
					$('.row-elipsis').ellipsis().tooltip();
				},
				buttons: [{
						extend: 'copy'
					},
					
				],
			});
			

		$('.exportExcelBtn').hide();
		new $.fn.dataTable.Buttons(listDataTableReport, {
			buttons: [{
				text: '<i class="fa fa-file-excel-o"></i> Export Excel',
				extend: 'excel',
				className: ' btn_modules_3 pull-left exportExcelBtn btn-xs btn-skin btn-primary',
				extension: '.xlsx'
			}]
		});
		// Add the Print button to the toolbox
		listDataTableReport.buttons(1, null).container().appendTo('.ibox-tools');
		$(".exportExcelBtn").removeClass("btn-default");
		$(".dt-buttons").addClass("pd-4");
		$(".dt-buttons").addClass("pull-left");
	});

	function refreshDataTableReport($reset_page = false) {
		$('#listDataTableReport').DataTable().ajax.reload(null, $reset_page);
	}

	// function printReport(transnum) {
    //     $.ajax({
    //         url: site_url + "hauling/hauling_recap/print_doc_pdf/",
    //         type: 'POST',
    //         dataType: 'html',
    //         data: { id : transnum },
    //         success: function(result) {
    //         $('#print-content').html(result);
    //                 $('#print-content').printThis({
    //                     importCSS: false,
    //                     importStyle: false,
    //                     canvas: true,
    //                     copyTagClasses: false,    // copy classes from the html & body tag
    //                     // loadCSS: ["</?=base_url()?>assets/css/cetak-document.css"],
    //                     loadCSS: ["</?=base_url()?>assets/css/print-doc-html.css"],
    //                 });    
    //         }
    //     });
    // }
	function printReport(trx){
		printDocPdf('hauling/hauling_recap/print_doc_pdf?transnum='+ trx,0);
	}

	function sendEmail(transnum) {
        $.ajax({
			type: "POST",
			url: site_url + "hauling/hauling_recap/send_email_recap",
			data: { id : transnum }, 
			dataType: 'json',
			success: function(response) {
				swal.fire(response['header'] || 'success', response['message'] || '', "success").then(() => {
					// window.location = site_url + "coalgetting_outbound/" + response['id'];
					// clearData();
				});
			},
			error: function(jqXhr, textStatus, errorThrown) {
				var error_message = 'internal error';
				if (jqXhr.responseJSON !== undefined) {
					error_message = jqXhr['responseJSON']['message'];
				}
				swal.fire('error', error_message, "error");
			}
		});
    }

</script>