<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vendor extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('vendor_model');
		$this->bc->set_title('Vendor');
		$this->bc->add('Vendor',base_url().'vendor');
		// $this->bc->add('Outbound',base_url().'coalgetting/coal_getting_outbound');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'vendor/main'
		);
		$this->load->view('tpl',$data);
	}

	function get_vendor(){
        $post = $this->input->post();
		
        $where = array();
        $where['tbl.vendor_id'] = $post['vendor_id'];
        $vendor_data = $this->vendor_model->get($where);
        if (!$vendor_data['vendor_id']){
            $this->error('ID Vendor Tidak Ditemukan');
        }
        $vendor_name = $vendor_data['vendor_name'];
        $vendor_mis = $vendor_data['vendor_mis'];
        $pit_cost = $vendor_data['pit_cost'];
        $stockr_cost = $vendor_data['stockr_cost'];
        $biaya_selisih = $vendor_data['biaya_selisih'];
        $this->result['vendor_name'] = $vendor_name;
        $this->result['vendor_mis'] = $vendor_mis;
        $this->result['pit_cost'] = $pit_cost;
        $this->result['stockr_cost'] = $stockr_cost;
        $this->result['biaya_selisih'] = $biaya_selisih;
        $this->success('ok');
    }

	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		
		$where = array();
		$where["(
			tbl.vendor_id LIKE '%$searchValue%'
			OR tbl.vendor_name LIKE '%$searchValue%'
			OR tbl.vendor_mis LIKE '%$searchValue%'
		)"] = NULL;
		
		$this->vendor_model->set_where($where);
		
		$list_count = $this->vendor_model->count();
		$this->vendor_model->set_limit($rowperpage);
		$this->vendor_model->set_offset($start);
		$this->vendor_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->vendor_model->get_list();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($vendor_id='')
	{
		$decoded_vendor_id = decode($vendor_id);
		$vendor_data = $this->vendor_model->get_list_get(array('vendor_id'=>$decoded_vendor_id));
		
		$data = array(
			'content' => 'vendor/input'
			,'vendor_data' => $vendor_data
		);

		$this->load->view('tpl',$data);
	}

	function save()
	{
		$data = array();
		$data['vendor_id'] 		= $this->input->post('t_vendor_id');
		$data['vendor_mis'] 	= $this->input->post('t_vendor_mis');
		$data['vendor_name'] 	= $this->input->post('t_vendor_name');
		$data['pit_cost'] 		= $this->input->post('t_pit_cost');
		$data['stockr_cost'] 	= $this->input->post('t_stockr_cost');
		$data['biaya_selisih'] 	= $this->input->post('t_biaya_selisih');
		
		$this->db->trans_start();		
		// simpan 
		$save = $this->vendor_model->save($data);
       
		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vendor_id']);
			$this->success('Save Success');
		}
	}

	function get_vendor_mis(){
        $post = $this->input->post();
		
        $where = array();
        $where['tbl.vendor_mis'] = $post['vendor_id'];
        $vendor_data = $this->vendor_model->get($where);
        if (!$vendor_data['vendor_id']){
            $this->error('ID Vendor Tidak Ditemukan');
        }
        $vendor_name = $vendor_data['vendor_name'];
        $this->result['vendor_name'] = $vendor_name;
        $this->success('ok');
    }

}