<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'main';
// $route['(:any)/function/(:any)'] = 'controller/function/$1/$2';
// $route['controller/function/(.+)'] = 'controller/controller/function/$1';
/* MODUL FINANCE */
/* SUB MODUL AP */
$route['dashboard/finance_accounting_dashboard/bank_account_balance'] = 'dashboard/bank_account_balance';
$route['dashboard/finance_accounting_dashboard/bank_account_balance/(:any)'] = 'dashboard/bank_account_balance/$1';
$route['dashboard/finance_accounting_dashboard/bank_account_balance/(:any)/(:any)'] = 'dashboard/bank_account_balance/$1/$2';

$route['dashboard/finance_accounting_dashboard/financial_dashboard'] = 'dashboard/financial_dashboard';
$route['dashboard/finance_accounting_dashboard/financial_dashboard/(:any)'] = 'dashboard/financial_dashboard/$1';
$route['dashboard/finance_accounting_dashboard/financial_dashboard/(:any)/(:any)'] = 'dashboard/financial_dashboard/$1/$2';

$route['hauling_dash'] = 'dashboard/hauling_dashboard';
$route['hauling_dash/(:any)'] = 'dashboard/hauling_dashboard/$1';

$route['dashboard_hauling/load_summary'] = 'dashboard/hauling_dashboard/load_summary';
$route['dashboard_hauling/load_chart'] = 'dashboard/hauling_dashboard/load_chart';
$route['dashboard_hauling/load_table1'] = 'dashboard/hauling_dashboard/load_table1';
$route['dashboard_hauling/load_table2'] = 'dashboard/hauling_dashboard/load_table2';
$route['dashboard_hauling/load_table3'] = 'dashboard/hauling_dashboard/load_table_alocationb';

$route['coalgetting_dash'] = 'dashboard/coalgetting_dashboard';
$route['coalgetting_dash/(:any)'] = 'dashboard/coalgetting_dashboard/$1';
$route['coalgetting_dash/load_chart_day'] = 'dashboard/coalgetting_dashboard/load_chart_day';
$route['coalgetting_dash/load_chart_month'] = 'dashboard/coalgetting_dashboard/load_chart_month';
$route['coalgetting_dash/load_summary'] = 'dashboard/coalgetting_dashboard/load_summary';
$route['coalgetting_dash/load_table'] = 'dashboard/coalgetting_dashboard/load_table';

$route['overburden_dash'] = 'dashboard/overburden_dashboard';
$route['overburden_dash/(:any)'] = 'dashboard/overburden_dashboard/$1';
$route['overburden_dash/load_chart_day'] = 'dashboard/overburden_dashboard/load_chart_day';
$route['overburden_dash/load_chart_month'] = 'dashboard/overburden_dashboard/load_chart_month';
$route['overburden_dash/load_summary'] = 'dashboard/overburden_dashboard/load_summary';
$route['overburden_dash/load_table'] = 'dashboard/overburden_dashboard/load_table';

$route['dashboard/load_summary'] = 'dashboard/overburden_dashboard/load_summary';
$route['dashboard/load_chart'] = 'dashboard/overburden_dashboard/load_chart';
$route['dashboard/load_table1'] = 'dashboard/overburden_dashboard/load_table1';
$route['dashboard/load_table2'] = 'dashboard/overburden_dashboard/load_table2';

$route['report_overburden'] = 'overburden/overburden_report';
$route['report_overburden/(:any)'] = 'overburden/overburden_report/$1';
// $route['overburden/report_overburden/b_detail/(:any)'] = 'overburden/overburden_report/detail/$1';
$route['report_overburden/listPage']= 'overburden/overburden_report/listPage';

$route['coalgetting_outbound'] = 'coalgetting/coal_getting_outbound';
$route['coalgetting_outbound/(:any)'] = 'coalgetting/coal_getting_outbound/$1';

$route['coalgetting_inbound'] = 'coalgetting/coal_getting_inbound';
$route['coalgetting_inbound/(:any)'] = 'coalgetting/coal_getting_inbound/$1';
$route['coalgetting_inbound_stockroom'] = 'coalgetting/coal_getting_inbound_stockroom';
$route['coalgetting_inbound_stockroom/(:any)'] = 'coalgetting/coal_getting_inbound_stockroom/$1';

$route['coalgetting_recap'] = 'coalgetting/coal_getting_recap';
$route['coalgetting_recap/(:any)'] = 'coalgetting/coal_getting_recap/$1';
$route['coalgetting_recap/listPageProcess']= 'coalgetting/coal_getting_recap/listPageProcess';
$route['coalgetting_recap/listPageReport']= 'coalgetting/coal_getting_recap/listPageReport';

$route['coalgetting_report'] = 'coalgetting/coal_getting_report';
$route['coalgetting_report/(:any)'] = 'coalgetting/coal_getting_report/$1';
$route['coalgetting_report/listPage']= 'coalgetting/coal_getting_report/listPage';

$route['hauling_outbound'] = 'hauling/hauling_outbound';
$route['hauling_outbound/(:any)'] = 'hauling/hauling_outbound/$1';

$route['stockroom_outbound'] = 'hauling/stockroom_outbound';
$route['stockroom_outbound/(:any)'] = 'hauling/stockroom_outbound/$1';

$route['hauling_inbound'] = 'hauling/hauling_inbound';
$route['hauling_inbound/(:any)'] = 'hauling/hauling_inbound/$1';

$route['hauling_recap'] = 'hauling/hauling_recap';
$route['hauling_recap/(:any)'] = 'hauling/hauling_recap/$1';
$route['hauling_recap/listPageProcess']= 'hauling/hauling_recap/listPageProcess';
$route['hauling_recap/listPageReport']= 'hauling/hauling_recap/listPageReport';

$route['hauling_report'] = 'hauling/hauling_report';
$route['hauling_report/(:any)'] = 'hauling/hauling_report/$1';
$route['hauling_report/listPage']= 'hauling/hauling_report/listPage';

$route['stockroom'] = 'master/stockroom';
$route['stockroom/input/(:any)'] = 'master/stockroom/input/$1';

$route['vendor'] = 'master/vendor';
$route['vendor/input/(:any)'] = 'master/vendor/input/$1';

$route['vehicle'] = 'master/vehicle';
$route['vehicle/input/(:any)'] = 'master/vehicle/input/$1';
$route['vehicle/data_vehicle'] = 'master/vehicle/get_vehicle';

$route['vehicle_mutation'] = 'master/vehicle_mutation';
$route['vehicle_mutation/(:any)'] = 'master/vehicle_mutation/$1';

$route['mining_recap'] = 'hauling/mining_recap';
$route['mining_recap/(:any)'] = 'hauling/mining_recap/$1';
$route['mining_recap/listPageProcess']= 'hauling/mining_recap/listPageProcess';
$route['mining_recap/listPageReport']= 'hauling/mining_recap/listPageReport';

$route['stockroom_movement'] = 'hauling/stockroom_movement';
$route['stockroom_movement/(:any)'] = 'hauling/stockroom_movement/$1';

$route['user'] = 'settings/user';
$route['user/input'] = 'settings/user/input';

/* UPLOAD ATTACHMENT*/
$route['up'] = 'main/upload';
$route['up/(:any)'] = 'main/upload/$1';

// update
$route['update'] = 'main/update';
$route['update/(:any)'] = 'main/update/$1';

$route['404_override'] = 'custom404';
$route['translate_uri_dashes'] = FALSE;

//api
$route['api'] = 'api/apiseal';
$route['api/upoverburden'] = 'api/apiseal/uploadOverburden';
$route['api/postweight'] = 'api/apiseal/postWeight';
// $route['api/getfromWeight'] = 'api/apiseal/getFromWeight';
