<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1\Call;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

class CallSummaryContext extends InstanceContext {
    /**
     * Initialize the CallSummaryContext
     *
     * @param Version $version Version that contains the resource
     * @param string $callSid The call_sid
     */
    public function __construct(Version $version, $callSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['callSid' => $callSid, ];

        $this->uri = '/Voice/' . \rawurlencode($callSid) . '/Summary';
    }

    /**
     * Fetch the CallSummaryInstance
     *
     * @param array|Options $options Optional Arguments
     * @return CallSummaryInstance Fetched CallSummaryInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): CallSummaryInstance {
        $options = new Values($options);

        $params = Values::of(['ProcessingState' => $options['processingState'], ]);

        $payload = $this->version->fetch('GET', $this->uri, $params);

        return new CallSummaryInstance($this->version, $payload, $this->solution['callSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.CallSummaryContext ' . \implode(' ', $context) . ']';
    }
}